/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.eo.tip;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.prop.Prop;
import io.enoa.toolkit.sys.OSKit;
import io.enoa.toolkit.text.TextKit;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Stream;

class _EnoaTip
implements Serializable {
    private Map<String, String> prop = new TreeMap<String, String>();

    _EnoaTip() {
    }

    _EnoaTip add(String file, Prop prop) {
        String suffix;
        Properties properties = prop.properties();
        if (file.endsWith("default.eo.properties")) {
            suffix = "default";
        } else {
            file = file.replace(".eo.properties", "");
            String[] fns = file.split("_");
            String local = fns[fns.length - 2];
            String lang = fns[fns.length - 1];
            suffix = local.concat("_").concat(lang);
        }
        properties.stringPropertyNames().forEach(name -> this.prop.put(TextKit.union(name, ".", suffix), prop.string((String)name)));
        properties.clear();
        return this;
    }

    private String format(String text, Object ... args) {
        if (TextKit.blanky(text)) {
            return text;
        }
        if (CollectionKit.isEmpty(args).booleanValue()) {
            return text;
        }
        Object[] fags = Stream.of(args).map(o -> o == null ? null : o.toString()).toArray(Object[]::new);
        return TextKit.format(text, fags);
    }

    String message(String key, Object ... args) {
        if (TextKit.blanky(key)) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.tip_key_not_null", new Object[0]));
        }
        String tip = this.prop.get(TextKit.union(key, ".", OSKit.language()));
        if (TextKit.blankn(tip)) {
            return this.format(tip, args);
        }
        tip = this.prop.get(key.concat(".default"));
        if (TextKit.blankn(tip)) {
            return this.format(tip, args);
        }
        return String.format("Not found message key: `%s`", key);
    }

    boolean exists(String key) {
        return this.prop.containsKey(key);
    }
}

