/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.date;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.thr.EoException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateKit {
    private static Map<String, SimpleDateFormat> CACHE;

    private DateKit() {
    }

    private static DateFormat dateFormat(String format) {
        SimpleDateFormat sdf;
        if (CACHE == null) {
            CACHE = new ConcurrentHashMap<String, SimpleDateFormat>();
        }
        if ((sdf = CACHE.get(format)) == null) {
            sdf = new SimpleDateFormat(format);
            CACHE.put(format, sdf);
        }
        return sdf;
    }

    public static Date parse(String text, String format) {
        try {
            if (text == null) {
                return null;
            }
            if (format == null) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.date_parse_format_null", new Object[0]));
            }
            return DateKit.dateFormat(format).parse(text);
        }
        catch (ParseException e) {
            throw new EoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static String format(Date date, String format) {
        try {
            DateFormat df = DateKit.dateFormat(format);
            return df.format(date);
        }
        catch (Exception e) {
            throw new EoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static String format(long ts, String format) {
        return DateKit.format(new Date(ts), format);
    }

    public static String format(String format) {
        return DateKit.format(System.currentTimeMillis(), format);
    }
}

