/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.convert;

import io.enoa.toolkit.convert.IConverter;
import io.enoa.toolkit.convert._BigDecimalConverter;
import io.enoa.toolkit.convert._BigIntegerConverter;
import io.enoa.toolkit.convert._BooleanConverter;
import io.enoa.toolkit.convert._ByteArrayConverter;
import io.enoa.toolkit.convert._ByteConverter;
import io.enoa.toolkit.convert._CharacterConverter;
import io.enoa.toolkit.convert._DateConverter;
import io.enoa.toolkit.convert._DoubleConverter;
import io.enoa.toolkit.convert._FloatConverter;
import io.enoa.toolkit.convert._IntegerConverter;
import io.enoa.toolkit.convert._LongConverter;
import io.enoa.toolkit.convert._ObjectConverter;
import io.enoa.toolkit.convert._ShortCoverter;
import io.enoa.toolkit.convert._SqlDateConverter;
import io.enoa.toolkit.convert._StringConverter;
import io.enoa.toolkit.convert._TimeConverter;
import io.enoa.toolkit.convert._TimestampConverter;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.thr.EoExpectException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

class TypeConverter {
    private static Map<Class<?>, IConverter<?, String>> converterMap;
    private static final TypeConverter me;

    private TypeConverter() {
        TypeConverter.install(String.class, new _StringConverter());
        TypeConverter.install(Integer.class, new _IntegerConverter(false));
        TypeConverter.install(Integer.TYPE, new _IntegerConverter(true));
        TypeConverter.install(Long.class, new _LongConverter(false));
        TypeConverter.install(Long.TYPE, new _LongConverter(true));
        TypeConverter.install(Double.class, new _DoubleConverter(false));
        TypeConverter.install(Double.TYPE, new _DoubleConverter(true));
        TypeConverter.install(Float.class, new _FloatConverter(false));
        TypeConverter.install(Float.TYPE, new _FloatConverter(true));
        TypeConverter.install(Boolean.class, new _BooleanConverter(false));
        TypeConverter.install(Boolean.TYPE, new _BooleanConverter(true));
        TypeConverter.install(Short.class, new _ShortCoverter(false));
        TypeConverter.install(Short.TYPE, new _ShortCoverter(true));
        TypeConverter.install(Byte.class, new _ByteConverter(false));
        TypeConverter.install(Byte.TYPE, new _ByteConverter(true));
        TypeConverter.install(java.util.Date.class, new _DateConverter());
        TypeConverter.install(Date.class, new _SqlDateConverter());
        TypeConverter.install(Time.class, new _TimeConverter());
        TypeConverter.install(Timestamp.class, new _TimestampConverter());
        TypeConverter.install(BigDecimal.class, new _BigDecimalConverter());
        TypeConverter.install(BigInteger.class, new _BigIntegerConverter());
        TypeConverter.install(byte[].class, new _ByteArrayConverter());
        TypeConverter.install(Object.class, new _ObjectConverter());
        TypeConverter.install(Character.class, new _CharacterConverter());
    }

    static <T> TypeConverter install(Class<T> type, IConverter<T, String> converter) {
        if (converterMap == null) {
            converterMap = new HashMap();
        }
        converterMap.put(type, converter);
        return me;
    }

    static Object convert(String text, Class<?> type) {
        if (type == String.class) {
            return "".equals(text) ? null : text;
        }
        if (text != null && "".equals(text = text.trim())) {
            return null;
        }
        IConverter<?, String> converter = converterMap.get(type);
        if (converter != null) {
            return converter.convert(text);
        }
        throw new EoExpectException(EnoaTipKit.message("eo.tip.toolkit.type_convert_unsupport", type.getName()), new Object[0]);
    }

    static boolean support(Class clazz) {
        return converterMap.keySet().stream().anyMatch(cz -> cz == clazz);
    }

    static {
        me = new TypeConverter();
    }
}

