/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ansi;

import io.enoa.toolkit.ansi.ANSI;
import io.enoa.toolkit.ansi.ANSIBody;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.number.NumberKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.text.TextReader;
import java.util.ArrayList;
import java.util.List;

class ANSIWrapper {
    static ANSIWrapper instance() {
        return Holder.INSTANCE;
    }

    private ANSIWrapper() {
    }

    private List<ANSIBody> bodies(String ansitext) {
        TextReader reader = new TextReader(ansitext);
        ArrayList<ANSIBody> bodies = new ArrayList<ANSIBody>();
        ArrayList<String> formats = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int level = 0;
        int levelStartIx = 0;
        boolean entry = false;
        while (reader.hasNext()) {
            char now = reader.next();
            if (now == '\u001b' && reader.next() == '[') {
                reader.back();
                if (!entry) {
                    entry = true;
                    if (++level > 1) {
                        levelStartIx = builder.length() - 1;
                    }
                    if (builder.length() > 0) {
                        ANSIBody body = ANSIBody.create(builder.toString());
                        bodies.add(body);
                        builder.delete(0, builder.length());
                    }
                    StringBuilder format = new StringBuilder(10);
                    boolean right = false;
                    int fix = -1;
                    int i = 0;
                    while (i < 10 && reader.hasNext()) {
                        fix = i++;
                        char fn = reader.next();
                        if (fn == 'm') {
                            format.append(fn);
                            right = true;
                            break;
                        }
                        format.append(fn);
                    }
                    if (!right) {
                        entry = false;
                        --level;
                        if (fix == -1) continue;
                        for (i = 0; i < fix + 1; ++i) {
                            reader.back();
                        }
                        continue;
                    }
                    formats.add(format.toString());
                    format.delete(0, format.length());
                    continue;
                }
                char n0 = reader.next();
                char n1 = reader.next();
                char n2 = reader.next();
                if (n0 == '[' && n1 == 'm' || n0 == '[' && n1 == '0' && n2 == 'm') {
                    if (n1 == 'm' && reader.hasNext()) {
                        reader.back();
                    }
                    entry = --level != 0;
                    String format = (String)formats.get(level);
                    String text = builder.toString();
                    if (entry) {
                        String leveltext = text.substring(levelStartIx);
                        ANSIBody body = ANSIBody.create(this.style(format), this.background(format), this.color(format), leveltext);
                        bodies.add(body);
                        formats.remove(level);
                        levelStartIx = 0;
                        continue;
                    }
                    ANSIBody body = ANSIBody.create(this.style(format), this.background(format), this.color(format), text);
                    bodies.add(body);
                    builder.delete(0, builder.length());
                    formats.remove(level);
                    continue;
                }
            }
            builder.append(now);
        }
        if (builder.length() > 0) {
            ANSIBody body = ANSIBody.create(builder.toString());
            bodies.add(body);
            builder.delete(0, builder.length());
        }
        return bodies;
    }

    private ANSI.Style style(String format) {
        String[] items;
        for (String item : items = this.items(format)) {
            if (item.length() != 1 || !NumberKit.isDigit(item)) continue;
            return ANSI.Style.of(NumberKit.integer(item));
        }
        return null;
    }

    private ANSI.Background background(String format) {
        String[] items;
        for (String item : items = this.items(format)) {
            if (item.length() == 1 || item.charAt(0) == '3' || !NumberKit.isDigit(item)) continue;
            return ANSI.Background.of(NumberKit.integer(item));
        }
        return null;
    }

    private ANSI.Color color(String format) {
        String[] items;
        for (String item : items = this.items(format)) {
            if (item.length() == 1 || item.charAt(0) == '4' || !NumberKit.isDigit(item)) continue;
            return ANSI.Color.of(NumberKit.integer(item));
        }
        return null;
    }

    private String[] items(String format) {
        if (TextKit.blanky(format)) {
            return CollectionKit.emptyArray(String.class);
        }
        format = format.substring(0, (format = format.substring(1)).endsWith(";m") ? format.length() - 2 : format.length() - 1);
        return format.split(";");
    }

    ANSI ansis(String text) {
        return new ANSI(this.bodies(text));
    }

    private static class Holder {
        private static final ANSIWrapper INSTANCE = new ANSIWrapper();

        private Holder() {
        }
    }
}

