/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.alg;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.thr.EoException;

public class UnitConvKit {
    public static long convert(long size, Unit from, Unit to) {
        switch (from) {
            case GB: {
                return UnitConvKit.convertGb(size, to);
            }
            case MB: {
                return UnitConvKit.convertMb(size, to);
            }
        }
        throw new EoException(EnoaTipKit.message("eo.tip.toolkit.not_support", new Object[0]), new Object[0]);
    }

    private static long convertMb(long size, Unit to) {
        switch (to) {
            case GB: {
                return size / 1024L;
            }
            case MB: {
                return size;
            }
            case KB: {
                return size * 1024L;
            }
            case BYTE: {
                return size * 1024L * 1024L;
            }
            case BIT: {
                return size * 1024L * 1024L * 1024L;
            }
        }
        throw new EoException(EnoaTipKit.message("eo.tip.toolkit.not_support", new Object[0]), new Object[0]);
    }

    private static long convertGb(long size, Unit to) {
        switch (to) {
            case GB: {
                return size;
            }
            case MB: {
                return size * 1024L;
            }
            case KB: {
                return size * 1024L * 1024L;
            }
            case BYTE: {
                return size * 1024L * 1024L * 1024L;
            }
            case BIT: {
                return size * 1024L * 1024L * 1024L * 1024L;
            }
        }
        throw new EoException(EnoaTipKit.message("eo.tip.toolkit.not_support", new Object[0]), new Object[0]);
    }

    public static enum Unit {
        BIT,
        BYTE,
        KB,
        MB,
        GB;

    }
}

