/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.text;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.text.TextKit;

public class PadKit {
    private PadKit() {
    }

    private static String fill(Direction direction, String text, String fill) {
        switch (direction) {
            case LEFT: {
                return TextKit.union(fill, text);
            }
            case RIGHT: {
                return TextKit.union(text, fill);
            }
        }
        throw new IllegalArgumentException("Unknow direction.");
    }

    private static String pad(Direction direction, String text, String fill, int number) {
        if (text == null) {
            return null;
        }
        if (fill == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.str_pad_fill_null", new Object[0]));
        }
        int n = number = number < 0 ? 0 : number;
        if (number == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int i = number;
        while (i-- > 0) {
            sb.append(fill);
        }
        return PadKit.fill(direction, text, sb.toString());
    }

    public static String lpad(String text, String fill, int number) {
        return PadKit.pad(Direction.LEFT, text, fill, number);
    }

    public static String rpad(String text, String fill, int number) {
        return PadKit.pad(Direction.RIGHT, text, fill, number);
    }

    private static String align(Direction direction, String text, String fill, int len) {
        if (text == null) {
            return null;
        }
        if (fill == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.str_pad_fill_null", new Object[0]));
        }
        if (text.length() > len) {
            return text.substring(0, len);
        }
        int fillNum = len - text.length();
        StringBuilder sb = new StringBuilder();
        int i = fillNum;
        while (i-- > 0) {
            sb.append(fill);
        }
        return PadKit.fill(direction, text, sb.toString());
    }

    public static String lalign(String text, String fill, int len) {
        return PadKit.align(Direction.LEFT, text, fill, len);
    }

    public static String ralign(String text, String fill, int len) {
        return PadKit.align(Direction.RIGHT, text, fill, len);
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

