/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.stream;

import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.thr.EoCloseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StreamKit {
    private static final int DEFAULT_BUFFER_SIZE = 8129;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final byte[] empty = new byte[0];

    private StreamKit() {
    }

    public static String string(byte[] bytes, Charset charset) {
        if (CollectionKit.isEmpty(bytes).booleanValue()) {
            return null;
        }
        return EnoaBinary.create(bytes, charset).string();
    }

    public static String string(InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            return null;
        }
        return StreamKit.string(StreamKit.bytes(stream), charset);
    }

    public static String string(ByteBuffer binary, Charset charset) {
        return StreamKit.string(binary.array(), charset);
    }

    public static EnoaBinary binary(InputStream stream, Charset charset) throws IOException {
        return EnoaBinary.create(StreamKit.bytes(stream), charset);
    }

    public static EnoaBinary binary(InputStream stream) throws IOException {
        return EnoaBinary.create(StreamKit.bytes(stream));
    }

    public static byte[] bytes(InputStream stream) throws IOException {
        byte[] buf = new byte[8129];
        int capacity = buf.length;
        int nread = 0;
        while (true) {
            int n;
            if ((n = stream.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity <<= 1;
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public static void close(Closeable ... closeables) {
        StreamKit.close(true, closeables);
    }

    public static void close(boolean skip, Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (skip) {
                    return;
                }
                throw new EoCloseException(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }

    public static void close(AutoCloseable ... closeables) {
        StreamKit.close(true, closeables);
    }

    public static void close(boolean skip, AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (skip) {
                    return;
                }
                throw new EoCloseException(e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }
}

