/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.number;

import io.enoa.toolkit.binary.EnoaBinary;

public class HexKit {
    private HexKit() {
    }

    public static boolean isHexNumber(String text) {
        int index = text.startsWith("-") ? 1 : 0;
        return text.startsWith("0x", index) || text.startsWith("0X", index) || text.startsWith("#", index);
    }

    public static String hex(byte[] bytes) {
        StringBuilder hs = new StringBuilder();
        for (byte b : bytes) {
            String _tmp = Integer.toHexString(b & 0xFF);
            if (_tmp.length() == 1) {
                hs.append('0');
            }
            hs.append(_tmp);
        }
        return hs.toString();
    }

    public static EnoaBinary binary(String text) {
        if (text == null) {
            return null;
        }
        int len = (text = text.trim()).length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < text.length(); i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + text.substring(i, i + 2)).intValue();
            }
            return EnoaBinary.create(b);
        }
        catch (Exception e) {
            return null;
        }
    }
}

