/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.http;

import io.enoa.toolkit.mark.IMarkVal;
import io.enoa.toolkit.text.TextKit;

public class ARL {
    private final Protocol protocol;
    private final String host;
    private final Integer port;
    private final String remain;
    private final String paras;
    private final String path;

    private ARL(Builder builder) {
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.port = builder.port;
        this.remain = builder.remain;
        this.paras = builder.paras;
        this.path = builder.path;
    }

    public String path() {
        return this.path;
    }

    public String paras() {
        return this.paras;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public Integer port() {
        return this.port;
    }

    public String remain() {
        return this.remain;
    }

    public String toString() {
        return "ARL{protocol=" + this.protocol + ", host='" + this.host + '\'' + ", port=" + this.port + ", remain='" + this.remain + '\'' + ", paras='" + this.paras + '\'' + ", path='" + this.path + '\'' + '}';
    }

    public static class Builder {
        private Protocol protocol;
        private String host;
        private Integer port;
        private String remain;
        private String paras;
        private String path;

        public ARL build() {
            return new ARL(this);
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder remain(String remain) {
            this.remain = remain;
            return this;
        }

        public Builder paras(String paras) {
            this.paras = paras;
            return this;
        }
    }

    public static enum Protocol implements IMarkVal
    {
        HTTP("http"),
        HTTPS("https");

        private final String val;

        private Protocol(String val) {
            this.val = val;
        }

        @Override
        public String val() {
            return this.val;
        }

        public static Protocol of(String text) {
            if (TextKit.blanky(text)) {
                return null;
            }
            for (Protocol protocol : Protocol.values()) {
                if (!protocol.val.equalsIgnoreCase(text)) continue;
                return protocol;
            }
            return null;
        }
    }
}

