/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.file;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.thr.EoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class FileKit {
    private static final Map<String, String> MIMES = new HashMap<String, String>(){
        {
            this.put("3gp", "video/3gpp");
            this.put("asf", "video/x-ms-asf");
            this.put("avi", "video/x-msvideo");
            this.put("m4u", "video/vnd.mpegurl");
            this.put("m4v", "video/x-m4v");
            this.put("mov", "video/quicktime");
            this.put("mp4", "video/mp4");
            this.put("mpg4", "video/mp4");
            this.put("mpe", "video/x-mpeg");
            this.put("mpeg", "video/mpg");
            this.put("mpg", "video/mpg");
            this.put("m3u", "audio/x-mpegurl");
            this.put("m4a", "audio/mp4a-latm");
            this.put("m4b", "audio/mp4a-latm");
            this.put("m4p", "audio/mp4a-latm");
            this.put("mp2", "x-mpeg");
            this.put("mp3", "audio/x-mpeg");
            this.put("mpga", "audio/mpeg");
            this.put("ogg", "audio/ogg");
            this.put("rmvb", "audio/x-pn-realaudio");
            this.put("wav", "audio/x-wav");
            this.put("wma", "audio/x-ms-wma");
            this.put("wmv", "audio/x-ms-wmv");
            this.put("c", "text/plain");
            this.put("java", "text/plain");
            this.put("conf", "text/plain");
            this.put("cpp", "text/plain");
            this.put("h", "text/plain");
            this.put("prop", "text/plain");
            this.put("props", "text/plain");
            this.put("rc", "text/plain");
            this.put("sh", "text/plain");
            this.put("log", "text/plain");
            this.put("txt", "text/plain");
            this.put("xml", "text/plain");
            this.put("md", "text/plain");
            this.put("scss", "text/plain");
            this.put("jscsrc", "text/plain");
            this.put("jshintrc", "text/plain");
            this.put("gitignore", "text/plain");
            this.put("editorconfig", "text/plain");
            this.put("properties", "text/plain");
            this.put("html", "text/html");
            this.put("htm", "text/html");
            this.put("css", "text/css");
            this.put("jpg", "image/jpeg");
            this.put("jpeg", "image/jpeg");
            this.put("bmp", "image/bmp");
            this.put("gif", "image/gif");
            this.put("png", "image/png");
            this.put("pneg", "image/png");
            this.put("svg", "image/svg+xml");
            this.put("", "application/octet-stream");
            this.put("json", "application/json");
            this.put("yml", "application/x-yaml");
            this.put("yaml", "application/x-yaml");
            this.put("bin", "application/octet-stream");
            this.put("exe", "application/octet-stream");
            this.put("class", "application/octet-stream");
            this.put("apk", "application/vnd.android.package-archive");
            this.put("doc", "application/msword");
            this.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put("xls", "application/vnd.ms-excel");
            this.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put("gtar", "application/x-gtar");
            this.put("gz", "application/x-gzip");
            this.put("jar", "application/java-archive");
            this.put("js", "application/x-javascript");
            this.put("mpc", "application/vnd.mpohun.certificate");
            this.put("msg", "application/vnd.ms-outlook");
            this.put("pdf", "application/pdf");
            this.put("pps", "application/vnd.ms-powerpoint");
            this.put("ppt", "application/vnd.ms-powerpoint");
            this.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put("rtf", "application/rtf");
            this.put("tar", "application/x-tar");
            this.put("tgz", "application/x-compressed");
            this.put("wps", "application/vnd.ms-works");
            this.put("z", "application/x-compress");
            this.put("zip", "application/x-zip-compressed");
        }
    };

    private FileKit() {
    }

    public static boolean delete(String file) {
        return FileKit.delete(new File(file));
    }

    public static boolean delete(Path path) {
        return FileKit.delete(path.toFile());
    }

    public static boolean delete(File file) {
        try {
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File _f : fs) {
                    FileKit.delete(_f);
                }
            }
            return file.delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Path mkdirs(String path) {
        return FileKit.mkdirs(Paths.get(path, new String[0]));
    }

    public static Path mkdirs(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        try {
            return Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String extension(String fileName) {
        int dotIdx = fileName.lastIndexOf(46);
        return dotIdx == -1 ? "" : fileName.substring(dotIdx + 1);
    }

    public static String extension(Path path) {
        return FileKit.extension(path.getFileName().toString());
    }

    public static boolean exists(String path) {
        return FileKit.exists(Paths.get(path, new String[0]));
    }

    public static boolean exists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    public static void write(Path path, ByteBuffer bytes) {
        if (path == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.write_not_file", "path == null"));
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.write_not_file", path.toString()));
        }
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            FileKit.mkdirs(path.getParent());
        }
        try (FileOutputStream out = new FileOutputStream(path.toFile());
             FileChannel channel = out.getChannel();){
            channel.write(bytes);
        }
        catch (IOException e) {
            throw new EoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static EnoaBinary read(Path path) {
        return FileKit.read(path, EoConst.CHARSET);
    }

    /*
     * Exception decompiling
     */
    public static EnoaBinary read(Path path, Charset charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path move(Path from, Path to) {
        try {
            return Files.move(from, to, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String probeContentType(Path path) {
        String contentType;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new RuntimeException(EnoaTipKit.message("eo.tip.toolkit.path_not_file", path.toString()));
        }
        try {
            contentType = Files.probeContentType(path);
        }
        catch (IOException e) {
            contentType = null;
        }
        if (contentType != null) {
            return contentType;
        }
        String suffix = FileKit.extension(path.toString());
        contentType = MIMES.get(suffix);
        return contentType;
    }
}

