/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.eo.tip;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.eo.tip._EnoaTip;
import io.enoa.toolkit.prop.Prop;
import io.enoa.toolkit.thr.EoException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EnoaTipKit {
    private static _EnoaTip tip;

    private static void loadTip() throws IOException {
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("eocnf/");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if ("jar".equals(url.getProtocol())) {
                String jarPath = url.toString().substring(0, url.toString().indexOf("!/") + 2);
                URL jarURL = new URL(jarPath);
                JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
                JarFile jarFile = jarCon.getJarFile();
                Enumeration<JarEntry> jarEntrys = jarFile.entries();
                while (jarEntrys.hasMoreElements()) {
                    JarEntry entry = jarEntrys.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".eo.properties") || entry.isDirectory()) continue;
                    tip.add(name, new Prop(name));
                }
            }
            if (!"file".equals(url.getProtocol())) continue;
            File resourcePath = new File(url.getPath());
            Object[] files = resourcePath.listFiles(pathname -> pathname.getName().endsWith(".eo.properties"));
            if (CollectionKit.isEmpty(files).booleanValue()) {
                throw new EoException("Not found tip config file.", new Object[0]);
            }
            for (Object file : files) {
                tip.add(((File)file).getName(), new Prop((File)file));
            }
        }
    }

    public static String message(String key, Object ... args) {
        return tip.message(key, args);
    }

    static {
        try {
            tip = new _EnoaTip();
            EnoaTipKit.loadTip();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

