/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.digest.base;

import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.digest.base.Base62;
import io.enoa.toolkit.digest.base.Base64;
import java.nio.charset.Charset;

public final class BaseKit {
    private BaseKit() {
    }

    public static String ebase64(byte[] bytes) {
        return Base64.encode(bytes);
    }

    public static String ebase64(String text) {
        return Base64.encode(text);
    }

    public static String ebase64(String text, Charset charset) {
        return Base64.encode(text, charset);
    }

    public static String ebase64url(byte[] bytes) {
        return Base64.encode(Base64.Mode.URLSAFE, bytes);
    }

    public static String ebase64url(String text) {
        return Base64.encode(Base64.Mode.URLSAFE, text);
    }

    public static String ebase64url(String text, Charset charset) {
        return Base64.encode(Base64.Mode.URLSAFE, text, charset);
    }

    public static EnoaBinary debase64(String text) {
        return Base64.decode(text);
    }

    public static EnoaBinary debase64(String text, Charset charset) {
        return Base64.decode(text, charset);
    }

    public static String debase64url(String text) {
        return Base64.decode(Base64.Mode.URLSAFE, text).string();
    }

    public static String debase64url(String text, Charset charset) {
        return Base64.decode(Base64.Mode.URLSAFE, text, charset).string();
    }

    public static String ebase62(byte[] bytes) {
        return EnoaBinary.create(Base62.createInstance().encode(bytes)).string();
    }

    public static String ebase62(String text, Charset charset) {
        return EnoaBinary.create(Base62.createInstance().encode(text.getBytes(charset))).string();
    }

    public static byte[] debase62(String text) {
        return Base62.createInstance().decode(text.getBytes());
    }

    public static String debase62(String text, Charset charset) {
        return EnoaBinary.create(Base62.createInstance().decode(text.getBytes())).string();
    }
}

