/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.collection;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.thr.EoException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionKit {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static Map<String, GenericEmptyArray> ARRAY_CACHE = new HashMap<String, GenericEmptyArray>();

    public static <T> T[] emptyArray(Class<T> clazz) {
        String name = clazz.getName();
        try {
            GenericEmptyArray<T> cahr = ARRAY_CACHE.get(name);
            if (cahr == null) {
                cahr = new GenericEmptyArray<T>(clazz);
                ARRAY_CACHE.put(name, cahr);
            }
            return cahr.array();
        }
        catch (Exception e) {
            throw new EoException(e);
        }
    }

    private static byte[] emptyBytes() {
        return EMPTY_BYTES;
    }

    private static int[] emptyInts() {
        return EMPTY_INTS;
    }

    public static <E> Boolean isEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> Boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static Boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static Boolean isEmpty(byte[] objects) {
        return objects == null || objects.length == 0;
    }

    public static Boolean isEmpty(int[] objects) {
        return objects == null || objects.length == 0;
    }

    public static <E> Boolean notEmpty(Collection<E> collection) {
        return CollectionKit.isEmpty(collection) == false;
    }

    public static <K, V> Boolean notEmpty(Map<K, V> map) {
        return CollectionKit.isEmpty(map) == false;
    }

    public static Boolean notEmpty(Object[] objects) {
        return CollectionKit.isEmpty(objects) == false;
    }

    public static Boolean notEmpty(byte[] objects) {
        return CollectionKit.isEmpty(objects) == false;
    }

    public static Boolean notEmpty(int[] objects) {
        return CollectionKit.isEmpty(objects) == false;
    }

    public static String[] distinct(String[] arrs) {
        return (String[])Arrays.stream(arrs).distinct().toArray(String[]::new);
    }

    public static Integer[] distinct(Integer[] arrs) {
        return (Integer[])Arrays.stream(arrs).distinct().toArray(Integer[]::new);
    }

    public static String[] concat(String[] first, String[] sec) {
        String[] res = new String[first.length + sec.length];
        System.arraycopy(first, 0, res, 0, first.length);
        System.arraycopy(sec, 0, res, first.length, sec.length);
        return res;
    }

    public static byte[] merge(byte[] bytes0, byte[] bytes1) {
        if (CollectionKit.isEmpty(bytes0).booleanValue()) {
            return CollectionKit.isEmpty(bytes1) != false ? CollectionKit.emptyBytes() : bytes1;
        }
        if (CollectionKit.isEmpty(bytes1).booleanValue()) {
            return CollectionKit.isEmpty(bytes0) != false ? CollectionKit.emptyBytes() : bytes0;
        }
        byte[] rets = new byte[bytes0.length + bytes1.length];
        System.arraycopy(bytes0, 0, rets, 0, bytes0.length);
        System.arraycopy(bytes1, 0, rets, bytes0.length, bytes1.length);
        return rets;
    }

    public static void clear(Collection ... collections) {
        for (Collection collection : collections) {
            if (collection == null) continue;
            collection.clear();
        }
    }

    public static void clear(Map ... maps) {
        for (Map map : maps) {
            if (map == null) continue;
            map.clear();
        }
    }

    public static void clear(Object[] ... arrays) {
        for (Object[] array : arrays) {
            if (array == null) continue;
            Arrays.fill(array, null);
        }
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static <T> T[] array(Object object) {
        ArrayList<Object> rets = new ArrayList<Object>();
        if (object == null) {
            return rets.toArray();
        }
        if (!CollectionKit.isArray(object)) {
            return rets.toArray();
        }
        int len = Array.getLength(object);
        for (int i = 0; i < len; ++i) {
            rets.add(Array.get(object, i));
        }
        return rets.toArray();
    }

    public static boolean contains(Object[] arr, Object target) {
        if (arr == null || target == null) {
            return false;
        }
        for (Object o : arr) {
            if (!o.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection colls, Object target) {
        if (colls == null || target == null) {
            return false;
        }
        return colls.stream().anyMatch(c -> c.equals(target));
    }

    public static <T> List<List<T>> split(Collection<T> colls, int size) {
        if (CollectionKit.isEmpty(colls).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> rets = new ArrayList<List<T>>();
        ArrayList<T> items = new ArrayList<T>();
        for (T coll : colls) {
            items.add(coll);
            if (size != items.size()) continue;
            rets.add(items);
            items = new ArrayList();
        }
        if (0 != items.size()) {
            rets.add(items);
        }
        return rets;
    }

    public static <T> List<List<T>> parts(Collection<T> colls, int parts) {
        if (CollectionKit.isEmpty(colls).booleanValue()) {
            return Collections.emptyList();
        }
        if (parts == 0) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.collection_parts_num_zero", new Object[0]));
        }
        ArrayList<List<T>> rets = new ArrayList<List<T>>();
        ArrayList<T> items = new ArrayList<T>();
        int pnum = colls.size() / parts;
        for (T coll : colls) {
            items.add(coll);
            if (items.size() != pnum) continue;
            rets.add(items);
            if (rets.size() >= parts) continue;
            items = new ArrayList();
        }
        return rets;
    }

    private static class GenericEmptyArray<T> {
        private T[] array;

        GenericEmptyArray(Class<T> clazz) {
            this.array = (Object[])Array.newInstance(clazz, 0);
        }

        T[] array() {
            return this.array;
        }
    }
}

