/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.bean;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.convert.ConvertKit;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.factory.ListFactory;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.map.OKv;
import io.enoa.toolkit.namecase.INameCase;
import io.enoa.toolkit.namecase.NamecaseKit;
import io.enoa.toolkit.namecase.NamecaseType;
import io.enoa.toolkit.number.NumberKit;
import io.enoa.toolkit.sys.ReflectKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BeanKit {
    public static Kv kv(Object bean) {
        return Kv.by(BeanKit.map(bean, true));
    }

    public static Kv kv(Object bean, boolean skipError) {
        return Kv.by(BeanKit.map(bean, skipError));
    }

    public static Kv kv(Object bean, INameCase namecase) {
        return Kv.by(BeanKit.map(bean, namecase));
    }

    public static Kv kv(Object bean, INameCase namecase, boolean skipError) {
        return Kv.by(BeanKit.map(bean, namecase, skipError));
    }

    public static OKv okv(Object bean) {
        return OKv.by(BeanKit.map(bean, true));
    }

    public static OKv okv(Object bean, boolean skipError) {
        return OKv.by(BeanKit.map(bean, skipError));
    }

    public static OKv okv(Object bean, INameCase namecase) {
        return OKv.by(BeanKit.map(bean, namecase));
    }

    public static OKv okv(Object bean, INameCase namecase, boolean skipError) {
        return OKv.by(BeanKit.map(bean, namecase, skipError));
    }

    public static Map<String, Object> map(Object bean) {
        return BeanKit.map(bean, true);
    }

    public static Map<String, Object> map(Object bean, boolean skipError) {
        return BeanKit.map(bean, NamecaseKit.namecase(NamecaseType.CASE_NONE), skipError);
    }

    public static Map<String, Object> map(Object bean, INameCase namecase) {
        return BeanKit.map(bean, namecase, true);
    }

    public static Map<String, Object> map(Object bean, INameCase namecase, boolean skipError) {
        try {
            if (bean == null) {
                return null;
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null && propertyDescriptors.length > 0) {
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    String propertyName = descriptor.getName();
                    if ("class".equals(propertyName)) continue;
                    Method readMethod = descriptor.getReadMethod();
                    Object result = readMethod.invoke(bean, new Object[0]);
                    ret.put(namecase.convert(propertyName), result);
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (skipError) {
                return null;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<Kv> kvs(List beans) {
        return BeanKit.maps(beans, true).stream().map(Kv::by).collect(Collectors.toList());
    }

    public static List<Kv> kvs(List beans, boolean skipError) {
        return BeanKit.maps(beans, skipError).stream().map(Kv::by).collect(Collectors.toList());
    }

    public static List<Kv> kvs(List beans, INameCase namecase) {
        return BeanKit.maps(beans, namecase).stream().map(Kv::by).collect(Collectors.toList());
    }

    public static List<Kv> kvs(List beans, INameCase namecase, boolean skipError) {
        return BeanKit.maps(beans, namecase, skipError).stream().map(Kv::by).collect(Collectors.toList());
    }

    public static List<OKv> okv(List beans) {
        return BeanKit.maps(beans, true).stream().map(OKv::by).collect(Collectors.toList());
    }

    public static List<OKv> okv(List beans, boolean skipError) {
        return BeanKit.maps(beans, skipError).stream().map(OKv::by).collect(Collectors.toList());
    }

    public static List<OKv> okv(List beans, INameCase namecase) {
        return BeanKit.maps(beans, namecase).stream().map(OKv::by).collect(Collectors.toList());
    }

    public static List<OKv> okv(List beans, INameCase namecase, boolean skipError) {
        return BeanKit.maps(beans, namecase, skipError).stream().map(OKv::by).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> maps(List beans) {
        return BeanKit.maps(beans, NamecaseKit.namecase(NamecaseType.CASE_NONE), true);
    }

    public static List<Map<String, Object>> maps(List beans, boolean skipError) {
        return BeanKit.maps(beans, NamecaseKit.namecase(NamecaseType.CASE_NONE), true);
    }

    public static List<Map<String, Object>> maps(List beans, INameCase namecase) {
        return BeanKit.maps(beans, namecase, true);
    }

    public static List<Map<String, Object>> maps(List beans, INameCase namecase, boolean skipError) {
        ArrayList<Map<String, Object>> rets = new ArrayList<Map<String, Object>>();
        beans.forEach(bean -> {
            Map<String, Object> item = BeanKit.map(bean, namecase, skipError);
            rets.add(item);
        });
        return rets;
    }

    public static <R> R reductionMap(Map map, Class<R> clazz) {
        return BeanKit.reductionMap(map, clazz, NamecaseKit.namecase(NamecaseType.CASE_NONE), true, false);
    }

    public static <R> R reductionMap(Map map, Class<R> clazz, boolean skipError, boolean ignorecase) {
        return BeanKit.reductionMap(map, clazz, NamecaseKit.namecase(NamecaseType.CASE_NONE), skipError, ignorecase);
    }

    public static <R> R reductionMap(Map map, Class<R> clazz, INameCase namecase) {
        return BeanKit.reductionMap(map, clazz, namecase, true, false);
    }

    public static <R> R reductionMap(Map mapx, Class<R> clazz, INameCase namecase, boolean skipError, boolean ignorecase) {
        Method[] methods;
        HashMap<Object, Object> _m;
        if (mapx == null) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        if (ignorecase) {
            _m = new HashMap<Object, Object>(mapx.size());
            mapx.forEach((key, val) -> _m.put(key == null ? null : key.toString().toUpperCase(), val));
        } else {
            _m = mapx;
        }
        R ret = ReflectKit.newInstance(clazz);
        for (Method method : methods = clazz.getMethods()) {
            if (method.getParameterCount() != 1) continue;
            String name = method.getName();
            Object val2 = _m.get(ignorecase ? TextKit.upper(name) : name);
            if (val2 == null) {
                if (!name.startsWith("set")) continue;
                name = TextKit.lowerFirst(name.substring(3));
                val2 = _m.get(ignorecase ? TextKit.upper(name) : name);
                if (val2 == null && (val2 = _m.get(namecase.convert(ignorecase ? TextKit.upper(name) : name))) == null) continue;
            }
            try {
                BeanKit.invoke(method, ret, val2);
            }
            catch (IllegalArgumentException e) {
                if (skipError) continue;
                Object[] paras = method.getParameters();
                throw new EoException(EnoaTipKit.message("eo.tip.toolkit.object_reduction_by_map_method_ill_arg", ReflectKit.methodString(clazz, method), CollectionKit.notEmpty(paras) != false ? ((Parameter)paras[0]).getType().getName() : "null", ReflectKit.intuitiveType(val2.getClass().getName())), (Throwable)e, new Object[0]);
            }
            catch (Exception e) {
                if (skipError) continue;
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        CollectionKit.clear(_m);
        return ret;
    }

    private static void invoke(Method method, Object object, Object val) throws Exception {
        Class<?> clazz = method.getParameterTypes()[0];
        if (Boolean.class.isAssignableFrom(clazz)) {
            if (val instanceof Boolean) {
                method.invoke(object, val);
                return;
            }
            if (val instanceof Number) {
                method.invoke(object, ConvertKit.bool((Number)val));
                return;
            }
            if (val instanceof String) {
                method.invoke(object, ConvertKit.bool((String)val));
                return;
            }
        }
        if (val instanceof Number) {
            Object[] pts = method.getParameterTypes();
            if (CollectionKit.isEmpty(pts).booleanValue()) {
                throw new IllegalArgumentException("NOT FOUND ARGUMENTS");
            }
            method.invoke(object, NumberKit.to((Number)val, (Class)pts[0]));
            return;
        }
        method.invoke(object, val);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz) {
        return BeanKit.reductionMaps(maps, clazz, ListFactory.def(), NamecaseKit.namecase(NamecaseType.CASE_NONE), true, false);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, INameCase namecase) {
        return BeanKit.reductionMaps(maps, clazz, ListFactory.def(), namecase, true, false);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, boolean skipError, boolean ignorecase) {
        return BeanKit.reductionMaps(maps, clazz, ListFactory.def(), NamecaseKit.namecase(NamecaseType.CASE_NONE), skipError, ignorecase);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, INameCase namecase, boolean skipError, boolean ignorecase) {
        return BeanKit.reductionMaps(maps, clazz, ListFactory.def(), namecase, skipError, ignorecase);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, ListFactory lister) {
        return BeanKit.reductionMaps(maps, clazz, lister, NamecaseKit.namecase(NamecaseType.CASE_NONE), true, false);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, ListFactory lister, INameCase namecase) {
        return BeanKit.reductionMaps(maps, clazz, lister, namecase, true, false);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, ListFactory lister, boolean skipError, boolean ignorecase) {
        return BeanKit.reductionMaps(maps, clazz, lister, NamecaseKit.namecase(NamecaseType.CASE_NONE), skipError, ignorecase);
    }

    public static <R> List<R> reductionMaps(List<Map> maps, Class<R> clazz, ListFactory lister, INameCase namecase, boolean skipError, boolean ignorecase) {
        if (maps == null) {
            return Collections.emptyList();
        }
        Collection rets = lister.collection();
        maps.forEach(arg_0 -> BeanKit.lambda$reductionMaps$2((List)rets, clazz, namecase, skipError, ignorecase, arg_0));
        return rets;
    }

    private static /* synthetic */ void lambda$reductionMaps$2(List rets, Class clazz, INameCase namecase, boolean skipError, boolean ignorecase, Map map) {
        rets.add(BeanKit.reductionMap(map, clazz, namecase, skipError, ignorecase));
    }
}

