/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ansi;

import io.enoa.toolkit.ansi.ANSIBody;
import io.enoa.toolkit.ansi.ANSIWrapper;
import io.enoa.toolkit.mark.IMarkIx;
import io.enoa.toolkit.text.LineBreak;
import io.enoa.toolkit.text.TextReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ANSI {
    private List<ANSIBody> bodies;
    private Map<Background, String> bgmap;
    private Map<Color, String> colormap;
    private boolean br;
    private String cssname;

    public static ANSI up() {
        return new ANSI();
    }

    public static ANSI wrap(String text) {
        return ANSIWrapper.instance().ansis(text);
    }

    public static String down(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        TextReader reader = new TextReader(text);
        boolean entry = false;
        while (reader.hasNext()) {
            char now = reader.next();
            if (now == '\u001b') {
                char next = reader.next();
                if (next == '[') {
                    entry = true;
                    continue;
                }
                reader.back();
                continue;
            }
            if (entry) {
                if (now != 'm') continue;
                entry = Boolean.FALSE;
                continue;
            }
            builder.append(now);
        }
        return builder.toString();
    }

    public ANSI() {
        this(new ArrayList<ANSIBody>());
    }

    ANSI(List<ANSIBody> bodies) {
        this.bodies = bodies;
    }

    public String string() {
        return ANSIBody.string(this.bodies);
    }

    public String html() {
        return ANSIBody.html(this.bodies, this.bgmap, this.colormap, this.cssname, this.br);
    }

    public ANSI br() {
        return this.br(Boolean.TRUE);
    }

    public ANSI br(boolean br) {
        this.br = br;
        return this;
    }

    public ANSI cssname(String cssname) {
        this.cssname = cssname;
        return this;
    }

    public ANSI color(Background background, String code) {
        if (this.bgmap == null) {
            this.bgmap = new HashMap<Background, String>();
        }
        this.bgmap.put(background, code);
        return this;
    }

    public ANSI color(Color color, String code) {
        if (this.colormap == null) {
            this.colormap = new HashMap<Color, String>();
        }
        this.colormap.put(color, code);
        return this;
    }

    public ANSI append(String text) {
        return this.append(text, null, null);
    }

    public ANSI append(String text, Style style) {
        return this.append(text, style, null, null);
    }

    public ANSI append(String text, Color color) {
        return this.append(text, color, null);
    }

    public ANSI append(String text, Background background) {
        return this.append(text, null, background);
    }

    public ANSI append(String text, Color color, Background background) {
        return this.append(text, null, color, background);
    }

    public ANSI append(String text, Style style, Color color, Background background) {
        this.bodies.add(ANSIBody.create(style, background, color, text));
        return this;
    }

    public ANSI text(String text, Style style, Color color, Background background) {
        return this.append(text, style, color, background);
    }

    public ANSI text(String text, Color color, Background background) {
        return this.append(text, color, background);
    }

    public ANSI text(String text, Color color) {
        return this.append(text, color);
    }

    public ANSI text(String text, Background background) {
        return this.append(text, background);
    }

    public ANSI text(String text) {
        return this.append(text);
    }

    public ANSI newline() {
        return this.newline("\n");
    }

    public ANSI newline(String newline) {
        return this.append(newline);
    }

    public ANSI newline(LineBreak newline) {
        return this.newline(newline.val());
    }

    public ANSI cr() {
        return this.newline(LineBreak.CR);
    }

    public ANSI lf() {
        return this.newline(LineBreak.LF);
    }

    public ANSI crlf() {
        return this.newline(LineBreak.CRLF);
    }

    public ANSI black(String text, Background background) {
        return this.append(text, Color.BLACK, background);
    }

    public ANSI red(String text, Background background) {
        return this.append(text, Color.RED, background);
    }

    public ANSI green(String text, Background background) {
        return this.append(text, Color.GREEN, background);
    }

    public ANSI yellow(String text, Background background) {
        return this.append(text, Color.YELLOW, background);
    }

    public ANSI blue(String text, Background background) {
        return this.append(text, Color.BLUE, background);
    }

    public ANSI magenta(String text, Background background) {
        return this.append(text, Color.MAGENTA, background);
    }

    public ANSI cyan(String text, Background background) {
        return this.append(text, Color.CYAN, background);
    }

    public ANSI white(String text, Background background) {
        return this.append(text, Color.WHITE, background);
    }

    public ANSI black(String text) {
        return this.append(text, Color.BLACK, null);
    }

    public ANSI red(String text) {
        return this.append(text, Color.RED, null);
    }

    public ANSI green(String text) {
        return this.append(text, Color.GREEN, null);
    }

    public ANSI yellow(String text) {
        return this.append(text, Color.YELLOW, null);
    }

    public ANSI blue(String text) {
        return this.append(text, Color.BLUE, null);
    }

    public ANSI magenta(String text) {
        return this.append(text, Color.MAGENTA, null);
    }

    public ANSI cyan(String text) {
        return this.append(text, Color.CYAN, null);
    }

    public ANSI white(String text) {
        return this.append(text, Color.WHITE, null);
    }

    public ANSI background(String text, Background background) {
        return this.append(text, null, background);
    }

    public ANSI bold(String text, Color color, Background background) {
        return this.append(text, Style.BOLD, color, background);
    }

    public ANSI bold(String text, Color color) {
        return this.append(text, Style.BOLD, color, null);
    }

    public ANSI bold(String text, Background background) {
        return this.append(text, Style.BOLD, null, background);
    }

    public ANSI bold(String text) {
        return this.append(text, Style.BOLD, null, null);
    }

    public ANSI underline(String text, Color color, Background background) {
        return this.append(text, Style.UNDERLINE, color, background);
    }

    public ANSI underline(String text, Color color) {
        return this.append(text, Style.UNDERLINE, color, null);
    }

    public ANSI underline(String text, Background background) {
        return this.append(text, Style.UNDERLINE, null, background);
    }

    public ANSI underline(String text) {
        return this.append(text, null, null, null);
    }

    public ANSI gray(String text, Color color, Background background) {
        return this.append(text, Style.GRAY, color, background);
    }

    public ANSI gray(String text, Color color) {
        return this.append(text, Style.GRAY, color, null);
    }

    public ANSI gray(String text, Background background) {
        return this.append(text, Style.GRAY, null, background);
    }

    public ANSI gray(String text) {
        return this.append(text, Style.GRAY, null, null);
    }

    public ANSI anti(String text, Color color, Background background) {
        return this.append(text, Style.ANTI, color, background);
    }

    public ANSI anti(String text, Color color) {
        return this.append(text, Style.ANTI, color, null);
    }

    public ANSI anti(String text, Background background) {
        return this.append(text, Style.ANTI, null, background);
    }

    public ANSI anti(String text) {
        return this.append(text, Style.ANTI, null, null);
    }

    public String toString() {
        return this.string();
    }

    public static enum Color implements IMarkIx
    {
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        WHITE(37);

        private final int ix;

        private Color(int ix) {
            this.ix = ix;
        }

        @Override
        public int ix() {
            return this.ix;
        }

        public static Color of(Integer ix) {
            if (ix == null) {
                return null;
            }
            for (Color color : Color.values()) {
                if (color.ix != ix) continue;
                return color;
            }
            return null;
        }
    }

    public static enum Background implements IMarkIx
    {
        BLACK(40),
        RED(41),
        GREEN(42),
        YELLOW(43),
        BLUE(44),
        MAGENTA(45),
        CYAN(46),
        WHITE(47);

        private final int ix;

        private Background(int ix) {
            this.ix = ix;
        }

        @Override
        public int ix() {
            return this.ix;
        }

        public static Background of(Integer ix) {
            if (ix == null) {
                return null;
            }
            for (Background background : Background.values()) {
                if (background.ix != ix) continue;
                return background;
            }
            return null;
        }
    }

    public static enum Style implements IMarkIx
    {
        NORMAL(0),
        BOLD(1),
        UNDERLINE(4),
        GRAY(5),
        ANTI(7);

        private final int ix;

        private Style(int ix) {
            this.ix = ix;
        }

        @Override
        public int ix() {
            return this.ix;
        }

        public static Style of(Integer ix) {
            if (ix == null) {
                return null;
            }
            for (Style style : Style.values()) {
                if (style.ix != ix) continue;
                return style;
            }
            return null;
        }
    }
}

