/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.value;

import io.enoa.toolkit.convert.ConvertKit;
import io.enoa.toolkit.convert.IConverter;
import io.enoa.toolkit.date.EnoaDate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class EnoaValue
implements Serializable {
    private Object value;
    public static final EnoaValue NULL = EnoaValue.with(null);

    private EnoaValue(Object value) {
        this.value = value;
    }

    public static EnoaValue with(Object value) {
        return new EnoaValue(value);
    }

    public Object origin() {
        return this.value;
    }

    public String string(String def) {
        return ConvertKit.string(this.value, def);
    }

    public String string() {
        return this.string(null);
    }

    public Number number(Number def) {
        return this.value instanceof Number ? (Number)ConvertKit.number((Number)this.value, def) : (Number)ConvertKit.number(this.string(), def);
    }

    public Number number() {
        return this.number(null);
    }

    public Integer integer(Integer def) {
        return this.value instanceof Number ? ConvertKit.integer((Number)this.value, def) : ConvertKit.integer(this.string(), def);
    }

    public Integer integer() {
        return this.integer(null);
    }

    public Long longer(Long def) {
        return this.value instanceof Number ? ConvertKit.longer((Number)this.value, def) : ConvertKit.longer(this.string(), def);
    }

    public Long longer() {
        return this.longer(null);
    }

    public Double doubler(Double def) {
        return this.value instanceof Number ? ConvertKit.doubler((Number)this.value, def) : ConvertKit.doubler(this.string(), def);
    }

    public Double doubler() {
        return this.doubler(null);
    }

    public Float floater(Float def) {
        return this.value instanceof Number ? ConvertKit.floater((Number)this.value, def) : ConvertKit.floater(this.string(), def);
    }

    public Float floater() {
        return this.floater(null);
    }

    public Short shorter(Short def) {
        return this.value instanceof Number ? ConvertKit.shorter((Number)this.value) : ConvertKit.shorter(this.string(), def);
    }

    public Short shorter() {
        return this.shorter(null);
    }

    public BigInteger bigint(BigInteger def) {
        return this.value instanceof Number ? ConvertKit.bigint((Number)this.value, def) : ConvertKit.bigint(this.string(), def);
    }

    public BigInteger bigint() {
        return this.bigint(null);
    }

    public BigDecimal bigdecimal(BigDecimal def) {
        return this.value instanceof Number ? ConvertKit.bigdecimal((Number)this.value, def) : ConvertKit.bigdecimal(this.string(), def);
    }

    public BigDecimal bigdecimal() {
        return this.bigdecimal(null);
    }

    public Boolean bool(Boolean def) {
        return this.value instanceof Number ? ConvertKit.bool((Number)this.value, def) : ConvertKit.bool(this.string(), def);
    }

    public Boolean bool() {
        return this.bool(null);
    }

    public Date date(String format, Date def) {
        if (this.value instanceof Date) {
            return EnoaDate.with((Date)this.value).date(def);
        }
        if (this.value instanceof Long) {
            return EnoaDate.with((Long)this.value).date(def);
        }
        return ConvertKit.date(this.string(), format, def);
    }

    public Date date(String format) {
        return this.date(format, null);
    }

    public Date date() {
        return this.date("yyyy-MM-dd", null);
    }

    public Timestamp timestamp(String format, Timestamp def) {
        if (this.value instanceof Date) {
            return EnoaDate.with((Date)this.value).timestamp(def);
        }
        if (this.value instanceof Long) {
            return EnoaDate.with((Long)this.value).timestamp(def);
        }
        return ConvertKit.timestamp(this.string(), format, def);
    }

    public Timestamp timestamp(String format) {
        return this.timestamp(format, null);
    }

    public Timestamp timestamp() {
        return this.timestamp("yyyy-MM-dd", null);
    }

    public <T> T as(T def) {
        return this.value == null ? def : this.as();
    }

    public <T> T as() {
        return (T)this.value;
    }

    public <R, P> R to(IConverter<R, P> converter) {
        return converter.convert(this.as());
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EnoaValue)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        EnoaValue that = (EnoaValue)other;
        if (that.value == null && this.value == null) {
            return true;
        }
        return that.value != null && that.value.equals(this.value);
    }

    public String toString() {
        return this.string();
    }
}

