/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.text;

import io.enoa.toolkit.text.TextKit;

public class TextReader<S extends TextReader> {
    private String text;
    private int len;
    private int position;
    private int line;
    private int cursor;

    public TextReader(String text) {
        this.text = text;
        this.len = text.length();
        this.line = 1;
    }

    public static TextReader with(String text) {
        return new TextReader(text);
    }

    public char peek() {
        if (this.position - 1 >= this.len) {
            return '\uffff';
        }
        return this.text.charAt(this.position - 1);
    }

    public char next() {
        if (!this.hasNext()) {
            return '\uffff';
        }
        char ch = this.text.charAt(this.position);
        ++this.position;
        ++this.cursor;
        if (ch == '\n') {
            ++this.line;
            this.cursor = 0;
        }
        return ch;
    }

    public int position() {
        return this.position;
    }

    public int line() {
        return this.line;
    }

    public int cursor() {
        return this.cursor;
    }

    public S back() {
        if (this.position == 0) {
            return (S)this;
        }
        --this.position;
        return (S)this;
    }

    public boolean hasNext() {
        return this.position < this.len;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        return TextKit.union("LENGTH: ", this.len, Character.valueOf(','), " POSITION: ", this.position, Character.valueOf(','), " LINE: ", this.line, Character.valueOf(','), " CURSOR: ", this.cursor, Character.valueOf(','), " TEXT => ", this.text);
    }
}

