/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.text;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.number.NumberKit;

public class TextKit {
    public static String lowerFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String upperFirst(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String text) {
        return TextKit.blanky(text);
    }

    public static boolean isBlank(String ... text) {
        return TextKit.blanky(text);
    }

    public static boolean notBlank(String text) {
        return TextKit.blankn(text);
    }

    public static boolean notBlank(String ... text) {
        return TextKit.blankn(text);
    }

    public static boolean blanky(String text) {
        if (text == null) {
            return true;
        }
        int len = text.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (text.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean blanky(String ... strings) {
        if (CollectionKit.isEmpty(strings).booleanValue()) {
            return true;
        }
        boolean pass = true;
        for (String string : strings) {
            if (TextKit.blanky(string)) continue;
            pass = false;
            break;
        }
        return pass;
    }

    public static boolean blankn(String str) {
        return !TextKit.blanky(str);
    }

    public static boolean blankn(String ... strings) {
        if (CollectionKit.isEmpty(strings).booleanValue()) {
            return false;
        }
        for (String str : strings) {
            if (!TextKit.blanky(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean nully(Object ... paras) {
        if (paras == null) {
            return true;
        }
        for (Object para : paras) {
            if (para != null) continue;
            return true;
        }
        return false;
    }

    public static boolean nulln(Object ... paras) {
        return !TextKit.nully(paras);
    }

    public static String lower(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String upper(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String nospace(String text, boolean extreme) {
        if (TextKit.blanky(text)) {
            return text;
        }
        if (!extreme) {
            return text.trim();
        }
        StringBuilder sb = new StringBuilder(text);
        block3: for (int ix = 0; sb.length() > ix; ++ix) {
            switch (sb.charAt(ix)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    sb.deleteCharAt(ix);
                    continue block3;
                }
            }
        }
        return sb.toString();
    }

    public static String nospace(String text) {
        return TextKit.nospace(text, false);
    }

    public static String union(int capacity, String text, Object ... union) {
        if (union == null) {
            return text;
        }
        StringBuilder ret = new StringBuilder(capacity);
        ret.append(text);
        for (Object u : union) {
            ret.append(u);
        }
        return ret.toString();
    }

    public static String union(String text, Object ... union) {
        return TextKit.union(text.length() + 16, text, union);
    }

    public static String ellipsis(String text) {
        return TextKit.ellipsis(text, 1000);
    }

    public static String ellipsis(String text, int len) {
        if (text == null) {
            return null;
        }
        if ("".equals(text)) {
            return "";
        }
        return TextKit.union(text.substring(0, text.length() > len ? len : text.length()), "...");
    }

    public static String reverse(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = text.length() - 1; i >= 0; --i) {
            ret.append(text.charAt(i));
        }
        return ret.toString();
    }

    public static String format(String message, Object ... formats) {
        if (message == null) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        StringBuilder ixb = new StringBuilder();
        boolean fillMode = false;
        for (char c : message.toCharArray()) {
            if (c == '}') {
                if (ixb.length() == 0) {
                    msg.append(c);
                    continue;
                }
                int _ix = NumberKit.integer(ixb.toString());
                if (_ix + 1 > formats.length) {
                    msg.append("{").append(_ix).append("}");
                } else {
                    msg.append(formats[_ix]);
                }
                ixb.delete(0, ixb.length());
                fillMode = false;
                continue;
            }
            if (!fillMode) {
                if (c == '{') {
                    fillMode = true;
                    continue;
                }
                msg.append(c);
                continue;
            }
            if (!NumberKit.isDigit(String.valueOf(c), false)) {
                msg.append('{').append(c);
                ixb.delete(0, ixb.length());
                fillMode = false;
                continue;
            }
            ixb.append(c);
        }
        ixb.delete(0, ixb.length());
        return msg.toString();
    }

    public static String removeRightChar(String text, char c) {
        return TextKit.removeChar(text, c, 0);
    }

    public static String removeLeftChar(String text, char c) {
        return TextKit.removeChar(text, c, 1);
    }

    private static String removeChar(String text, char c, int direct) {
        StringBuilder _text = new StringBuilder(text);
        int len = _text.length();
        boolean has = Boolean.FALSE;
        int leftOffset = 0;
        int i = len;
        while (i-- > 0) {
            int ix = direct == 1 ? leftOffset : i;
            char _c = _text.charAt(ix);
            if (has) {
                if (_c != c) break;
                _text.deleteCharAt(ix);
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r' && (_c == ' ' || _c == '\t' || _c == '\n' || _c == '\r')) {
                if (direct != 1) continue;
                ++leftOffset;
                continue;
            }
            if (_c != c) break;
            _text.deleteCharAt(ix);
            has = Boolean.TRUE;
        }
        return _text.toString();
    }

    public static String safeBlank(String text) {
        return TextKit.safeBlank(text, null);
    }

    public static String safeBlank(String text, String def) {
        return TextKit.blanky(text) ? def : text;
    }
}

