/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.sys;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoReflectException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class ReflectKit {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new EoReflectException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static boolean hasClazz(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String methodString(Class clazz, Method method) {
        StringBuilder sb = new StringBuilder();
        if (clazz != null) {
            sb.append(clazz.getName()).append("#");
        }
        sb.append(method.getName());
        sb.append("(");
        Object[] paras = method.getParameters();
        if (CollectionKit.notEmpty(paras).booleanValue()) {
            int i = 0;
            for (Object para : paras) {
                sb.append(((Parameter)para).getName()).append("::").append(((Parameter)para).getType().getName());
                if (i + 1 < paras.length) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String intuitiveType(String type) {
        if (type == null) {
            return null;
        }
        if (!type.startsWith("[")) {
            return type;
        }
        switch (type) {
            case "[I": {
                return "int[]";
            }
            case "[S": {
                return "short[]";
            }
            case "[J": {
                return "long[]";
            }
            case "[B": {
                return "byte[]";
            }
            case "[C": {
                return "char[]";
            }
            case "[D": {
                return "double[]";
            }
            case "[F": {
                return "float[]";
            }
            case "[Z": {
                return "boolean[]";
            }
        }
        if (type.startsWith("[L")) {
            return TextKit.union(type.substring(2), "[]");
        }
        return type;
    }
}

