/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.sys;

import io.enoa.toolkit.value.EnoaValue;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EnvKit {
    private static Map<String, String> env;
    private static final EnvKit me;

    private EnvKit() {
    }

    public static EnvKit set(String name, String value) {
        env.put(name, value);
        System.setProperty(name, value);
        return me;
    }

    public static EnoaValue value(String name) {
        return EnoaValue.with(env.get(name));
    }

    public static String string(String name, String def) {
        return EnvKit.value(name).string(def);
    }

    public static String string(String name) {
        return EnvKit.value(name).string();
    }

    public static Integer integer(String name, Integer def) {
        return EnvKit.value(name).integer(def);
    }

    public static Integer integer(String name) {
        return EnvKit.value(name).integer();
    }

    public static Long longer(String name, Long def) {
        return EnvKit.value(name).longer(def);
    }

    public static Long longer(String name) {
        return EnvKit.value(name).longer();
    }

    public static Boolean bool(String name, Boolean def) {
        return EnvKit.value(name).bool(def);
    }

    public static Boolean bool(String name) {
        return EnvKit.value(name).bool();
    }

    public static boolean exists(String name) {
        return EnvKit.string(name) != null;
    }

    static {
        me = new EnvKit();
        env = new HashMap<String, String>(System.getenv());
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object name = enumeration.nextElement();
            env.put(name.toString(), System.getProperty(name.toString()));
        }
    }
}

