/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.prop;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.value.EnoaValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;

public class Prop {
    private Properties properties = null;

    public Prop(String fileName) {
        this(fileName, EoConst.CHARSET);
    }

    public Prop(String fileName, Charset encoding) {
        try (InputStream inputStream = this.getClassLoader().getResourceAsStream(fileName);){
            if (inputStream == null) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.prop_file_notfound_classpath", fileName));
            }
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(EnoaTipKit.message("eo.tip.toolkit.prop_load_error", new Object[0]), e);
        }
    }

    public Prop(File file) {
        this(file, EoConst.CHARSET);
    }

    public Prop(File file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.prop_file_null", new Object[0]));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.prop_file_notfound_file", file.getName()));
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(new InputStreamReader((InputStream)inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(EnoaTipKit.message("eo.tip.toolkit.prop_load_error", new Object[0]), e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    public EnoaValue value(String key) {
        return EnoaValue.with(this.properties.getProperty(key));
    }

    public String string(String key) {
        return this.value(key).string();
    }

    public String string(String key, String def) {
        return this.value(key).string(def);
    }

    public Integer integer(String key) {
        return this.value(key).integer();
    }

    public Integer integer(String key, Integer def) {
        return this.value(key).integer(def);
    }

    public Long longer(String key) {
        return this.value(key).longer();
    }

    public Long longer(String key, Long def) {
        return this.value(key).longer(def);
    }

    public Boolean bool(String key) {
        return this.value(key).bool();
    }

    public Boolean bool(String key, Boolean def) {
        return this.value(key).bool(def);
    }

    public Set<String> keys() {
        return this.properties.stringPropertyNames();
    }

    public boolean exists(String key) {
        return this.properties.containsKey(key);
    }

    public Properties properties() {
        return this.properties;
    }
}

