/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.number;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.number.HexKit;
import io.enoa.toolkit.text.TextKit;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberKit {
    private NumberKit() {
    }

    private static BigInteger decodeBigInteger(String text) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (text.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (text.startsWith("0x", index) || text.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        }
        if (text.startsWith("#", index)) {
            ++index;
            radix = 16;
        }
        if (text.startsWith("0", index) && text.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(text.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static boolean isNumber(String text) {
        boolean hasDot = false;
        int i = text.length();
        while (i-- > 0) {
            char at = text.charAt(i);
            if (at == '-' && i == 0) continue;
            if (at == '.') {
                if (hasDot) {
                    return false;
                }
                hasDot = true;
                continue;
            }
            if (Character.isDigit(at)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String text) {
        return NumberKit.isDigit(text, false);
    }

    public static boolean isDigit(String text, boolean negative) {
        int i = text.length();
        while (i-- > 0) {
            char at = text.charAt(i);
            if (negative && at == '-' && i == 0 || Character.isDigit(at)) continue;
            return false;
        }
        return true;
    }

    public static Number to(Number origin, Class to) {
        if (origin == null) {
            return null;
        }
        if (to == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_target_null", new Object[0]));
        }
        if (to.isInstance(origin)) {
            return origin;
        }
        if (Integer.class == to || Integer.TYPE == to) {
            long value = origin.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_cant", origin, origin.getClass().getName(), to.getName()));
            }
            return origin.intValue();
        }
        if (Long.class == to || Long.TYPE == to) {
            BigInteger bigInt = null;
            if (origin instanceof BigInteger) {
                bigInt = (BigInteger)origin;
            }
            if (origin instanceof BigDecimal) {
                bigInt = ((BigDecimal)origin).toBigInteger();
            }
            if (bigInt != null && (bigInt.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bigInt.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0)) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_cant", origin, origin.getClass().getName(), to.getName()));
            }
            return origin.longValue();
        }
        if (Double.class == to || Double.TYPE == to) {
            return origin.doubleValue();
        }
        if (Float.class == to || Float.TYPE == to) {
            return Float.valueOf(origin.floatValue());
        }
        if (BigDecimal.class == to) {
            return new BigDecimal(origin.toString());
        }
        if (Short.class == to || Short.TYPE == to) {
            long value = origin.longValue();
            if (value < -32768L || value > 32767L) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_cant", origin, origin.getClass().getName(), to.getName()));
            }
            return origin.shortValue();
        }
        if (Byte.class == to || Byte.TYPE == to) {
            long value = origin.longValue();
            if (value < -128L || value > 127L) {
                throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_cant", origin, origin.getClass().getName(), to.getName()));
            }
            return origin.byteValue();
        }
        if (BigInteger.class == to) {
            if (origin instanceof BigDecimal) {
                return ((BigDecimal)origin).toBigInteger();
            }
            return BigInteger.valueOf(origin.longValue());
        }
        throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_cant", origin, origin.getClass().getName(), to.getName()));
    }

    public static <T extends Number> T to(String text, Class<T> to) {
        if (text == null) {
            return null;
        }
        if (to == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_to_target_null", new Object[0]));
        }
        String trimmed = TextKit.nospace(text, true);
        if (to.equals(Integer.class)) {
            return (T)(HexKit.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (to.equals(Long.class)) {
            return (T)(HexKit.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (to.equals(Float.class)) {
            return (T)Float.valueOf(trimmed);
        }
        if (to.equals(Double.class)) {
            return (T)Double.valueOf(trimmed);
        }
        if (to.equals(BigDecimal.class) || to.equals(Number.class)) {
            return (T)new BigDecimal(trimmed);
        }
        if (to.equals(Short.class)) {
            return (T)(HexKit.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (to.equals(BigInteger.class)) {
            return (T)(HexKit.isHexNumber(trimmed) ? NumberKit.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (to.equals(Byte.class)) {
            return (T)(HexKit.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.number_str_to_cant", text, to.getName()));
    }

    public static Integer integer(Number number) {
        return (Integer)NumberKit.to(number, Integer.class);
    }

    public static Double doubler(Number number) {
        return (Double)NumberKit.to(number, Double.class);
    }

    public static Float floater(Number number) {
        return (Float)NumberKit.to(number, Float.class);
    }

    public static Long longer(Number number) {
        return (Long)NumberKit.to(number, Long.class);
    }

    public static BigDecimal bigdecimal(Number number) {
        return (BigDecimal)NumberKit.to(number, BigDecimal.class);
    }

    public static BigInteger bigint(Number number) {
        return (BigInteger)NumberKit.to(number, BigInteger.class);
    }

    public static Short shorter(Number number) {
        return (Short)NumberKit.to(number, Short.class);
    }

    public static Integer integer(String text) {
        return NumberKit.to(text, Integer.class);
    }

    public static Double doubler(String text) {
        return NumberKit.to(text, Double.class);
    }

    public static Float floater(String text) {
        return NumberKit.to(text, Float.class);
    }

    public static Long longer(String text) {
        return NumberKit.to(text, Long.class);
    }

    public static BigDecimal bigdecimal(String text) {
        return NumberKit.to(text, BigDecimal.class);
    }

    public static BigInteger bigint(String text) {
        return NumberKit.to(text, BigInteger.class);
    }

    public static Short shorter(String text) {
        return NumberKit.to(text, Short.class);
    }
}

