/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.namecase;

import io.enoa.toolkit.namecase.INameCase;
import io.enoa.toolkit.namecase.NamecaseType;
import io.enoa.toolkit.namecase.icase.CamelCaseLower;
import io.enoa.toolkit.namecase.icase.CamelCaseUpper;
import io.enoa.toolkit.namecase.icase.NoneCase;
import io.enoa.toolkit.namecase.icase.UnderlineCase;
import java.util.HashMap;
import java.util.Map;

public class NamecaseKit {
    private NamecaseKit() {
    }

    public static INameCase namecase(NamecaseType type) {
        return Case.namecase(type);
    }

    public static String camelcaselower(String text) {
        return Case.convert(NamecaseType.CASE_CAMEL_LOWER, text);
    }

    public static String camelcaseupper(String text) {
        return Case.convert(NamecaseType.CASE_CAMEL_UPPER, text);
    }

    public static String nonecase(String text) {
        return Case.convert(NamecaseType.CASE_NONE, text);
    }

    public static String underline(String text) {
        return Case.convert(NamecaseType.CASE_UNDERLINE, text);
    }

    public static String convert(String text, INameCase namecase) {
        return namecase.convert(text);
    }

    private static class Case {
        private static final Map<NamecaseType, INameCase> CASE_CACHE = new HashMap<NamecaseType, INameCase>(){
            {
                this.put(NamecaseType.CASE_CAMEL_LOWER, new CamelCaseLower());
                this.put(NamecaseType.CASE_NONE, new NoneCase());
                this.put(NamecaseType.CASE_CAMEL_UPPER, new CamelCaseUpper());
                this.put(NamecaseType.CASE_UNDERLINE, new UnderlineCase());
            }
        };

        private Case() {
        }

        public static String convert(NamecaseType type, String text) {
            return Case.namecase(type).convert(text);
        }

        static INameCase namecase(NamecaseType type) {
            return CASE_CACHE.get((Object)type);
        }
    }
}

