/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.http;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.http.UriKit;
import io.enoa.toolkit.text.TextKit;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class UrlKit {
    private static Map<String, String> SYMBOLMAPPING = new HashMap<String, String>();

    private UrlKit() {
    }

    private static String encodeUrl(String url, Charset charset) {
        try {
            return URLEncoder.encode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void initSymbolMapping() {
        String[] symbols;
        Charset utf8 = Charset.forName("UTF-8");
        for (String symbol : symbols = new String[]{"~", "!", "@", "#", "$", "^", "&", "*", "(", ")", "=", "[", "]", "{", "}", "|", "\\", ";", ":", "'", "\"", ",", "<", ".", ">", "?", "/"}) {
            String esym = UrlKit.encodeUrl(symbol, utf8);
            SYMBOLMAPPING.put(esym, symbol);
        }
    }

    private static String reductionSymbol(String encodeUrl) {
        for (String k : SYMBOLMAPPING.keySet()) {
            encodeUrl = encodeUrl.replace(k, SYMBOLMAPPING.get(k));
        }
        return encodeUrl;
    }

    public static String encode(String url, Charset charset) {
        if (url == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.url_encode_null", new Object[0]));
        }
        return UrlKit.reductionSymbol(UrlKit.encodeUrl(url, charset));
    }

    public static String decode(String url, Charset charset) {
        if (url == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.url_decode_null", new Object[0]));
        }
        try {
            return URLDecoder.decode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String encode(String url) {
        return UrlKit.encode(url, EoConst.CHARSET);
    }

    public static String decode(String url) {
        return UrlKit.decode(url, EoConst.CHARSET);
    }

    public static String correct(String url) {
        String temp = TextKit.lower(url);
        if (!temp.startsWith("http://") && !temp.startsWith("https://")) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.url_protocol_fail", new Object[0]));
        }
        int pix = temp.indexOf("://");
        String protocol = url.substring(0, pix);
        String content = url.substring(pix + 3);
        String uri = UriKit.correct(content).substring(1);
        return TextKit.union(protocol, "://", uri);
    }

    public static String[] analysis(String url) {
        int ix = url.indexOf("/", url.indexOf("//") + 2);
        String host = url.substring(0, ix);
        String remain = url.substring(ix);
        return new String[]{host, remain};
    }

    static {
        UrlKit.initSymbolMapping();
    }
}

