/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.digest.base;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.binary.EnoaBinary;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

final class Base64 {
    private static IBase64 DELEGATE = Base64.isPresent("java.util.Base64", Base64.class.getClassLoader()) ? new Java8Base64() : new Java67Base64();

    private Base64() {
    }

    public static String encode(Mode mode, byte[] value) {
        String _v = DELEGATE.encode(value);
        if (mode == Mode.GENERALLY) {
            return _v;
        }
        _v = _v.replace('+', '-');
        _v = _v.replace('/', '_');
        _v = _v.replace("=", "");
        return _v;
    }

    public static String encode(Mode mode, String value) {
        return Base64.encode(mode, value, EoConst.CHARSET);
    }

    public static String encode(Mode mode, String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        return Base64.encode(mode, val);
    }

    public static String encode(byte[] value) {
        return Base64.encode(Mode.GENERALLY, value);
    }

    public static String encode(String value) {
        return Base64.encode(Mode.GENERALLY, value);
    }

    public static String encode(String value, Charset charset) {
        byte[] val = value.getBytes(charset);
        return Base64.encode(Mode.GENERALLY, val);
    }

    public static EnoaBinary decode(Mode mode, String value) {
        return Base64.decode(mode, value, EoConst.CHARSET);
    }

    public static EnoaBinary decode(Mode mode, String value, Charset charset) {
        EnoaBinary binary = EnoaBinary.create(DELEGATE.decode(value), charset);
        if (mode != Mode.URLSAFE) {
            return binary;
        }
        String _v = binary.string();
        _v = _v.replace('-', '+');
        int mod4 = (_v = _v.replace('_', '/')).length() % 4;
        if (mod4 > 0) {
            _v = _v + "====".substring(mod4);
        }
        return EnoaBinary.create(_v.getBytes(charset), charset);
    }

    public static EnoaBinary decode(String value) {
        return Base64.decode(Mode.GENERALLY, value, EoConst.CHARSET);
    }

    public static EnoaBinary decode(String value, Charset charset) {
        return Base64.decode(Mode.GENERALLY, value, charset);
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static class Java67Base64
    implements IBase64 {
        private Java67Base64() {
        }

        @Override
        public String encode(byte[] data) {
            return DatatypeConverter.printBase64Binary((byte[])data);
        }

        @Override
        public byte[] decode(String base64) {
            return DatatypeConverter.parseBase64Binary((String)base64);
        }
    }

    private static class Java8Base64
    implements IBase64 {
        private Java8Base64() {
        }

        @Override
        public String encode(byte[] value) {
            return java.util.Base64.getEncoder().encodeToString(value);
        }

        @Override
        public byte[] decode(String value) {
            return java.util.Base64.getDecoder().decode(value);
        }
    }

    private static interface IBase64 {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }

    public static enum Mode {
        GENERALLY,
        URLSAFE;

    }
}

