/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.digest;

import io.enoa.toolkit.EoConst;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class DigestKit {
    public static final long FNV_OFFSET_BASIS_64 = -3750763034362895579L;
    public static final long FNV_PRIME_64 = 1099511628211L;
    private static final SecureRandom random = new SecureRandom();
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final char[] CHAR_ARRAY = "_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static long fnv1a64(String key) {
        long hash = -3750763034362895579L;
        int size = key.length();
        for (int i = 0; i < size; ++i) {
            hash ^= (long)key.charAt(i);
            hash *= 1099511628211L;
        }
        return hash;
    }

    public static String md5(String text) {
        return DigestKit.hash("MD5", text);
    }

    public static String sha1(String text) {
        return DigestKit.hash("SHA-1", text);
    }

    public static String sha256(String text) {
        return DigestKit.hash("SHA-256", text);
    }

    public static String sha384(String text) {
        return DigestKit.hash("SHA-384", text);
    }

    public static String sha512(String text) {
        return DigestKit.hash("SHA-512", text);
    }

    public static String hash(String algorithm, String text) {
        return DigestKit.hash(algorithm, text, EoConst.CHARSET);
    }

    public static String hash(String algorithm, String text, Charset charset) {
        return DigestKit.hash(algorithm, text.getBytes(charset));
    }

    public static String hash(String algorithm, byte[] binary) {
        byte[] bytes = DigestKit.digest(algorithm).digest(binary);
        return DigestKit.hex(bytes);
    }

    public static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm.toUpperCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String hex(byte[] bytes) {
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            ret.append(HEX_DIGITS[b >> 4 & 0xF]);
            ret.append(HEX_DIGITS[b & 0xF]);
        }
        return ret.toString();
    }

    public static String salt(int saltLength) {
        StringBuilder salt = new StringBuilder(saltLength);
        for (int i = 0; i < saltLength; ++i) {
            salt.append(CHAR_ARRAY[random.nextInt(CHAR_ARRAY.length)]);
        }
        return salt.toString();
    }

    public static String saltSha256() {
        return DigestKit.salt(32);
    }

    public static String saltSha512() {
        return DigestKit.salt(64);
    }

    public static boolean slowEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }
}

