/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.convert;

import io.enoa.toolkit.convert.IConverter;
import io.enoa.toolkit.convert.TypeConverter;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.number.NumberKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoException;
import io.enoa.toolkit.value.Vae;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConvertKit {
    private ConvertKit() {
    }

    public static String string(Object obj) {
        return ConvertKit.string(obj, null, Boolean.TRUE);
    }

    public static String string(Object obj, boolean checkblank) {
        return ConvertKit.string(obj, null, checkblank);
    }

    public static String string(Object obj, String def) {
        return ConvertKit.string(obj, def, Boolean.TRUE);
    }

    public static String string(Object obj, String def, boolean checkblank) {
        if (obj == null) {
            return def;
        }
        String _string = obj.toString();
        return checkblank ? (TextKit.blanky(_string) ? def : _string) : _string;
    }

    public static Number number(String text, Number def) {
        return TextKit.blanky(text) ? (Number)def : (Number)NumberKit.to(text, Number.class);
    }

    public static Number number(String text) {
        return ConvertKit.number(text, null);
    }

    public static Number number(Number number, Number def) {
        Number ret = NumberKit.to(number, Number.class);
        return Vae.nulldef(ret, def);
    }

    public static Number number(Number number) {
        return ConvertKit.number(number, null);
    }

    public static Integer integer(String text) {
        return ConvertKit.integer(text, null);
    }

    public static Integer integer(String text, Integer def) {
        return TextKit.blanky(text) ? def : NumberKit.integer(text);
    }

    public static Integer integer(Number number, Integer def) {
        Integer ret = NumberKit.integer(number);
        return Vae.nulldef(ret, def);
    }

    public static Integer integer(Number number) {
        return ConvertKit.integer(number, null);
    }

    public static Long longer(String text) {
        return ConvertKit.longer(text, null);
    }

    public static Long longer(String text, Long def) {
        return TextKit.blanky(text) ? def : NumberKit.longer(text);
    }

    public static Long longer(Number number, Long def) {
        Long ret = NumberKit.longer(number);
        return Vae.nulldef(ret, def);
    }

    public static Long longer(Number number) {
        return ConvertKit.longer(number, null);
    }

    public static Double doubler(String text) {
        return ConvertKit.doubler(text, null);
    }

    public static Double doubler(String text, Double def) {
        return TextKit.blanky(text) ? def : NumberKit.doubler(text);
    }

    public static Double doubler(Number number, Double def) {
        Double ret = NumberKit.doubler(number);
        return Vae.nulldef(ret, def);
    }

    public static Double doubler(Number number) {
        return ConvertKit.doubler(number, null);
    }

    public static Float floater(String text, Float def) {
        return TextKit.blanky(text) ? def : NumberKit.floater(text);
    }

    public static Float floater(String text) {
        return ConvertKit.floater(text, null);
    }

    public static Float floater(Number number, Float def) {
        Float ret = NumberKit.floater(number);
        return Vae.nulldef(ret, def);
    }

    public static Float floater(Number number) {
        return ConvertKit.floater(number, null);
    }

    public static Short shorter(String text, Short def) {
        return TextKit.blanky(text) ? def : NumberKit.shorter(text);
    }

    public static Short shorter(String text) {
        return ConvertKit.shorter(text, null);
    }

    public static Short shorter(Number number, Short def) {
        Short ret = NumberKit.shorter(number);
        return Vae.nulldef(ret, def);
    }

    public static Short shorter(Number number) {
        return ConvertKit.shorter(number, null);
    }

    public static BigInteger bigint(String text, BigInteger def) {
        return TextKit.blanky(text) ? def : NumberKit.bigint(text);
    }

    public static BigInteger bigint(String text) {
        return ConvertKit.bigint(text, null);
    }

    public static BigInteger bigint(Number number, BigInteger def) {
        BigInteger ret = NumberKit.bigint(number);
        return Vae.nulldef(ret, def);
    }

    public static BigInteger bigint(Number number) {
        return ConvertKit.bigint(number, null);
    }

    public static BigDecimal bigdecimal(String text, BigDecimal def) {
        return TextKit.blanky(text) ? def : NumberKit.bigdecimal(text);
    }

    public static BigDecimal bigdecimal(String text) {
        return ConvertKit.bigdecimal(text, null);
    }

    public static BigDecimal bigdecimal(Number number, BigDecimal def) {
        BigDecimal ret = NumberKit.bigdecimal(number);
        return Vae.nulldef(ret, def);
    }

    public static BigDecimal bigdecimal(Number number) {
        return ConvertKit.bigdecimal(number, null);
    }

    public static Boolean bool(String text) {
        return ConvertKit.bool(text, null);
    }

    public static Boolean bool(String text, Boolean def) {
        if (TextKit.blanky(text)) {
            return def;
        }
        if ("1".equals(text = text.trim().toLowerCase()) || "true".equals(text)) {
            return Boolean.TRUE;
        }
        if ("0".equals(text) || "false".equals(text)) {
            return Boolean.FALSE;
        }
        throw new EoException(EnoaTipKit.message("eo.tip.toolkit.convert_cant_bool", text), new Object[0]);
    }

    public static Boolean bool(Number number, Boolean def) {
        if (number == null) {
            return def;
        }
        return ConvertKit.longer(number) == 0L;
    }

    public static Boolean bool(Number number) {
        return ConvertKit.bool(number, Boolean.FALSE);
    }

    public static Date date(String text) {
        return ConvertKit.date(text, "yyyy-MM-dd HH:mm:ss.SSS", null);
    }

    public static Date date(String text, String format) {
        return ConvertKit.date(text, format, null);
    }

    public static Date date(String text, String format, Date def) {
        try {
            if (TextKit.blanky(text)) {
                return def;
            }
            return new SimpleDateFormat(format).parse(text.trim());
        }
        catch (ParseException e) {
            throw new EoException(EnoaTipKit.message("eo.tip.toolkit.convert_cant_date", text), new Object[0]);
        }
    }

    public static Timestamp timestamp(String text, String format, Timestamp def) {
        Date date = ConvertKit.date(text, format);
        if (date == null) {
            return def;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp timestamp(String text, String format) {
        return ConvertKit.timestamp(text, format, null);
    }

    public static Timestamp timestamp(String text) {
        return ConvertKit.timestamp(text, "yyyy-MM-dd HH:mm:ss.SSS", null);
    }

    public static <R> R as(Object value) {
        return ConvertKit.as(value, null);
    }

    public static <R> R as(Object value, R def) {
        return (R)(value == null ? def : value);
    }

    public static <R, P> R to(P value, IConverter<R, P> converter) {
        return converter.convert(value);
    }

    public static <T> T to(String value, Class<T> clazz) {
        Object ret = TypeConverter.convert(value, clazz);
        return (T)ret;
    }

    public static boolean supportConvert(Class clazz) {
        return TypeConverter.support(clazz);
    }

    public static <T> void install(Class<T> type, IConverter<T, String> converter) {
        TypeConverter.install(type, converter);
    }
}

