/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.http;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.file.FileKit;
import io.enoa.toolkit.stream.StreamKit;
import io.enoa.toolkit.thr.EoException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;

public abstract class ResponseBody {
    public abstract long length();

    public abstract byte[] bytes();

    public ByteBuffer buffer() {
        return ByteBuffer.wrap(this.bytes());
    }

    public EnoaBinary binary() {
        return EnoaBinary.create((byte[])this.bytes());
    }

    public static ResponseBody create(String content) {
        return ResponseBody.create(content, EoConst.CHARSET);
    }

    public static ResponseBody create(String content, Charset charset) {
        if (content == null) {
            throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.resp_body_cant_null", (Object[])new Object[0]), new Object[0]);
        }
        byte[] bytes = content.getBytes(charset);
        return ResponseBody.create(bytes);
    }

    public static ResponseBody create(Path path) {
        if (path == null) {
            throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.resp_body_cant_null", (Object[])new Object[0]), new Object[0]);
        }
        EnoaBinary ebinary = FileKit.read((Path)path);
        byte[] bytes = ebinary.bytes();
        return ResponseBody.create(bytes);
    }

    public static ResponseBody create(final byte[] bytes) {
        if (bytes == null) {
            throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.resp_body_cant_null", (Object[])new Object[0]), new Object[0]);
        }
        return new ResponseBody(){

            @Override
            public long length() {
                return bytes.length;
            }

            @Override
            public byte[] bytes() {
                return bytes;
            }
        };
    }

    public String toString() {
        try {
            byte[] bytes = this.bytes();
            if (CollectionKit.isEmpty((byte[])bytes).booleanValue()) {
                return null;
            }
            String body = StreamKit.string((byte[])bytes, (Charset)EoConst.CHARSET);
            if (body == null) {
                return "";
            }
            return body.substring(0, body.length() < 2048 ? body.length() - 1 : 2047);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

