/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.factory.http;

import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.cos.EoxInputStream;
import io.enoa.repeater.cos.FilePart;
import io.enoa.repeater.cos.MultipartBody;
import io.enoa.repeater.cos.MultipartParser;
import io.enoa.repeater.cos.ParamPart;
import io.enoa.repeater.cos.Part;
import io.enoa.repeater.factory.http.EoxAbstractRequest;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.http.UFile;
import io.enoa.toolkit.alg.UnitConvKit;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.file.FileKit;
import io.enoa.toolkit.stream.StreamKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EoxAbstractCosRequest
extends EoxAbstractRequest {
    private Map<String, List<String>> binparas = new HashMap<String, List<String>>();
    private List<UFile> ufiles = new ArrayList<UFile>();

    protected void handleUpload(InputStream stream, EoxConfig config, EoxNameRuleFactory rule) {
        String contentType = this.header("content-type");
        if (TextKit.blanky((String)contentType) || !contentType.startsWith("multipart/form-data")) {
            return;
        }
        try {
            Part part;
            MultipartParser parser = new MultipartParser(new MultipartBody.Builder().stream(new EoxInputStream(stream)).contentType(contentType).contentLength(Long.parseLong(this.header("content-length"))).build(), (int)UnitConvKit.convert((long)config.maxUploadSize(), (UnitConvKit.Unit)UnitConvKit.Unit.MB, (UnitConvKit.Unit)UnitConvKit.Unit.BYTE), true, true, config.charset().name());
            FileKit.mkdirs((Path)config.tmp());
            while ((part = parser.readNextPart()) != null) {
                String name = part.getName();
                if (name == null) {
                    throw new IOException("Malformed input: parameter name missing (known Opera 7 bug)");
                }
                if (part.isParam()) {
                    ParamPart paramPart = (ParamPart)part;
                    String value = paramPart.getStringValue();
                    List<String> paras = this.binparas.get(name);
                    if (paras != null) {
                        paras.add(value);
                        continue;
                    }
                    paras = new ArrayList<String>();
                    paras.add(value);
                    this.binparas.put(name, paras);
                }
                if (!part.isFile()) continue;
                FilePart filePart = (FilePart)part;
                String fileName = filePart.getFileName();
                if (fileName == null) {
                    this.ufiles.add(new UFile.Builder().name(name).tmp(config.tmp()).build());
                    continue;
                }
                String originName = filePart.getFileName();
                UFile.Builder ufile = new UFile.Builder().name(name).tmp(config.tmp()).originName(originName);
                if (config.holdFile()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        filePart.writeTo((OutputStream)baos);
                        this.ufiles.add(ufile.filename(originName).binary(baos.toByteArray()).build());
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (baos == null) continue;
                        if (throwable != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        baos.close();
                        continue;
                    }
                }
                String newname = rule.name(config.tmp(), originName);
                filePart.writeTo(config.tmp().toString(), newname);
                this.ufiles.add(ufile.filename(newname).path(Paths.get(config.tmp().toString(), new String[0]).resolve(newname)).build());
            }
        }
        catch (IOException e) {
            try {
                throw new EoException((Throwable)e);
            }
            catch (Throwable throwable) {
                StreamKit.close((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        StreamKit.close((Closeable[])new Closeable[]{stream});
    }

    protected Map<String, String[]> paraMap(Map<String, List<String>> map1) {
        if (CollectionKit.notEmpty(this.binparas).booleanValue()) {
            return super.paraMap(map1, this.binparas);
        }
        Map<String, String[]> ret = this.mapListToArray(map1);
        if (CollectionKit.notEmpty(ret).booleanValue()) {
            return Collections.unmodifiableMap(ret);
        }
        return null;
    }

    @Override
    public UFile[] files() {
        String contentType = this.header("content-type");
        if (TextKit.blanky((String)contentType) || !contentType.startsWith("multipart/form-data")) {
            return (UFile[])CollectionKit.emptyArray(UFile.class);
        }
        return this.ufiles.toArray(new UFile[this.ufiles.size()]);
    }

    @Override
    public UFile[] files(String name) {
        return (UFile[])this.ufiles.stream().filter(u -> u.name().equals(name)).toArray(UFile[]::new);
    }

    @Override
    public UFile file(String name) {
        Object[] files = this.files(name);
        if (CollectionKit.isEmpty((Object[])files).booleanValue()) {
            return null;
        }
        return files[0];
    }

    @Override
    public void clear() {
        CollectionKit.clear((Map[])new Map[]{this.binparas});
        CollectionKit.clear((Collection[])new Collection[]{this.ufiles});
    }
}

