/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater;

import io.enoa.repeater.config.ssl.EoxSSLConfig;
import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.sys.EnvKit;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;

public class EoxConfig {
    private final boolean debug;
    private final String context;
    private final Charset charset;
    private final boolean info;
    private final boolean infoUseLog;
    private final int soTimeout;
    private final Path tmp;
    private final int maxUploadSize;
    private final EoxSSLConfig ssl;
    private final Kv other;
    private final boolean holdFile;
    private static EoxConfig current;

    private EoxConfig(Builder builder) {
        this.debug = builder.debug;
        this.context = builder.context;
        this.charset = builder.charset;
        this.info = builder.info;
        this.infoUseLog = builder.infoUseLog;
        this.soTimeout = builder.soTimeout;
        this.tmp = builder.tmp;
        this.maxUploadSize = builder.maxUploadSize;
        this.ssl = builder.ssl;
        this.other = builder.other;
        this.holdFile = builder.holdFile;
    }

    public static EoxConfig def() {
        return new Builder().ssl(EoxSSLConfig.def()).build();
    }

    static EoxConfig current() {
        return current;
    }

    static void current(EoxConfig config) {
        current = config;
    }

    public boolean debug() {
        return this.debug;
    }

    public String context() {
        return this.context;
    }

    public Charset charset() {
        return this.charset;
    }

    public boolean info() {
        return this.info;
    }

    public boolean infoUseLog() {
        return this.infoUseLog;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public Path tmp() {
        return this.tmp;
    }

    public int maxUploadSize() {
        return this.maxUploadSize;
    }

    public EoxSSLConfig ssl() {
        return this.ssl;
    }

    public Kv other() {
        return this.other;
    }

    public boolean holdFile() {
        return this.holdFile;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean debug = false;
        private String context = "/";
        private Charset charset = EoConst.CHARSET;
        private boolean info = true;
        private boolean infoUseLog = false;
        private int soTimeout = 5000;
        private Path tmp = Paths.get(EnvKit.string((String)"java.io.tmpdir"), new String[0]);
        private int maxUploadSize = 2;
        private EoxSSLConfig ssl;
        private Kv other;
        private boolean holdFile = false;

        public Builder() {
        }

        public Builder(EoxConfig config) {
            this();
            this.debug = config.debug;
            this.context = config.context;
            this.charset = config.charset;
            this.info = config.info;
            this.infoUseLog = config.infoUseLog;
            this.soTimeout = config.soTimeout;
            this.tmp = config.tmp;
            this.maxUploadSize = config.maxUploadSize;
            this.ssl = config.ssl;
            this.other = config.other;
            this.holdFile = config.holdFile;
        }

        public EoxConfig build() {
            return new EoxConfig(this);
        }

        public Builder debug() {
            return this.debug(true);
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder tmp(Path tmp) {
            this.tmp = tmp;
            return this;
        }

        public Builder maxUploadSize(int maxUploadSize) {
            this.maxUploadSize = maxUploadSize;
            return this;
        }

        public Builder ssl(EoxSSLConfig ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder info() {
            return this.info(true);
        }

        public Builder info(boolean info) {
            this.info = info;
            return this;
        }

        public Builder infoUseLog(boolean infoUseLog) {
            this.infoUseLog = infoUseLog;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder holdFile() {
            return this.holdFile(true);
        }

        public Builder holdFile(boolean holdFile) {
            this.holdFile = holdFile;
            return this;
        }

        public Builder other(Kv other) {
            this.other = other;
            return this;
        }
    }
}

