/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.http;

import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.file.FileKit;
import io.enoa.toolkit.thr.EoException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class UFile {
    private final String name;
    private final String originName;
    private final String filename;
    private final Path tmp;
    private final Path path;
    private final byte[] binary;
    private final Type type;
    private static ExecutorService ES = Executors.newSingleThreadExecutor();

    private UFile(Builder builder) {
        this.name = builder.name;
        this.originName = builder.originName;
        this.filename = builder.filename;
        this.path = builder.path;
        this.binary = builder.binary;
        this.type = builder.type;
        this.tmp = builder.tmp;
    }

    public String name() {
        return this.name;
    }

    public String originName() {
        return this.originName;
    }

    public String filename() {
        return this.filename;
    }

    public Path path() {
        if (this.type == Type.FILE) {
            return this.path;
        }
        Path path = this.tmp.resolve(this.filename);
        return this.move(path);
    }

    public byte[] bytes() {
        if (this.type == Type.BINARY) {
            return this.binary;
        }
        return FileKit.read((Path)this.path).bytes();
    }

    public EnoaBinary binary() {
        if (this.type == Type.BINARY) {
            return EnoaBinary.create((byte[])this.bytes());
        }
        return FileKit.read((Path)this.path);
    }

    public File file() {
        Path path = this.path();
        return path == null ? null : path.toFile();
    }

    public Path move(String to) throws EoException {
        return this.move(Paths.get(to, new String[0]));
    }

    public Path move(Path to) throws EoException {
        Path folder = to.getParent();
        if (!FileKit.exists((Path)folder)) {
            FileKit.mkdirs((Path)folder);
        }
        switch (this.type) {
            case FILE: {
                Path newFile = FileKit.move((Path)this.path, (Path)to);
                if (newFile == null) {
                    throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.file_move_fail", (Object[])new Object[]{this.path.toString(), to.toString()}), new Object[0]);
                }
                return newFile;
            }
            case BINARY: {
                FileKit.write((Path)to, (ByteBuffer)ByteBuffer.wrap(this.bytes()));
                return to;
            }
        }
        throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.file_move_fail", (Object[])new Object[]{this.path.toString(), to.toString()}), new Object[0]);
    }

    public Future<Path> asyncMove(ExecutorService es, String to) throws EoException {
        return this.asyncMove(es, Paths.get(to, new String[0]));
    }

    public Future<Path> asyncMove(ExecutorService es, Path to) throws EoException {
        if (this.path == null) {
            throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.file_cant_move", (Object[])new Object[0]), new Object[0]);
        }
        if (to == null) {
            throw new EoException(EnoaTipKit.message((String)"eo.tip.repeater.file_move_to_null", (Object[])new Object[0]), new Object[0]);
        }
        return es.submit(() -> this.move(to));
    }

    public Future<Path> asyncMove(String to) throws EoException {
        return this.asyncMove(ES, Paths.get(to, new String[0]));
    }

    public Future<Path> asyncMove(Path to) throws EoException {
        return this.asyncMove(ES, to);
    }

    public void delete() {
        if (this.type == Type.FILE) {
            FileKit.delete((Path)this.path);
            return;
        }
        Path path = this.tmp.resolve(this.filename);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        FileKit.delete((Path)path);
    }

    public String toString() {
        return "UFile{name='" + this.name + '\'' + ", originName='" + this.originName + '\'' + ", filename='" + this.filename + '\'' + (this.type == null ? "ERROR UFILE." : (this.type == Type.FILE ? ", path=" + this.path : ", binary=" + Arrays.toString(this.binary))) + '}';
    }

    public static class Builder {
        private String name;
        private String originName;
        private String filename;
        private Path tmp;
        private Path path;
        private byte[] binary;
        private Type type;

        public UFile build() {
            return new UFile(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder originName(String originName) {
            this.originName = originName;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            this.type = Type.FILE;
            return this;
        }

        public Builder binary(byte[] binary) {
            this.binary = binary;
            this.type = Type.BINARY;
            return this;
        }

        public Builder tmp(Path tmp) {
            this.tmp = tmp;
            return this;
        }
    }

    private static enum Type {
        FILE,
        BINARY;

    }
}

