/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.http;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.stream.StreamKit;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class RequestBody {
    private RequestBody() {
    }

    public abstract Charset charset();

    public abstract ByteBuffer binary();

    public String string() {
        return StreamKit.string((ByteBuffer)this.binary(), (Charset)this.charset());
    }

    public String string(Charset charset) {
        return StreamKit.string((ByteBuffer)this.binary(), (Charset)charset);
    }

    public byte[] bytes() {
        return this.binary().array();
    }

    public static RequestBody create(final byte[] body, final Charset charset) {
        if (CollectionKit.isEmpty((byte[])body).booleanValue()) {
            return null;
        }
        return new RequestBody(){

            @Override
            public Charset charset() {
                return charset;
            }

            @Override
            public ByteBuffer binary() {
                return ByteBuffer.wrap(body);
            }
        };
    }

    public static RequestBody create(String body, Charset charset) {
        if (body == null) {
            return null;
        }
        return RequestBody.create(body.getBytes(charset), charset);
    }
}

