/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.factory.error;

import io.enoa.log.Log;
import io.enoa.repeater.Repeater;
import io.enoa.repeater.factory.error.EoxErrorRenderFactory;
import io.enoa.repeater.http.HttpStatus;
import io.enoa.repeater.http.Response;
import io.enoa.repeater.http.ResponseBody;
import io.enoa.toolkit.sys.ThrowableKit;

class EoxErrorRenderImpl
implements EoxErrorRenderFactory {
    EoxErrorRenderImpl() {
    }

    @Override
    public Response renderError(HttpStatus stat) {
        return new Response.Builder().status(stat).contentType("text/html").body(ResponseBody.create(String.format("error %d", stat.code()), Repeater.config().charset())).build();
    }

    @Override
    public Response renderError(HttpStatus stat, Throwable e) {
        if (e != null) {
            Log.error((String)e.getMessage(), (Throwable)e);
        }
        return new Response.Builder().status(stat).contentType("text/html").body(ResponseBody.create(String.format("error %d <br> <pre>%s</pre>", stat.code(), ThrowableKit.string((Throwable)e)), Repeater.config().charset())).build();
    }

    @Override
    public Response renderError(HttpStatus stat, String message) {
        return this.renderError(stat);
    }

    @Override
    public Response renderError(HttpStatus stat, String message, Throwable e) {
        return this.renderError(stat, e);
    }
}

