/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.mq.rabbitmq;

import com.rabbitmq.client.Address;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class RabbitConfig {
    private final List<Address> addresses;
    private final String user;
    private final String passwd;
    private final String virtualHost;
    private final ExecutorService executor;
    private final String name;
    private final Integer channelNumber;

    private RabbitConfig(Builder builder) {
        this.addresses = builder.addresses;
        this.user = builder.user;
        this.passwd = builder.passwd;
        this.virtualHost = builder.virtualHost;
        this.executor = builder.executor;
        this.name = builder.name;
        this.channelNumber = builder.channelNumber;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public String user() {
        return this.user;
    }

    public String passwd() {
        return this.passwd;
    }

    public String virtualHost() {
        return this.virtualHost;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public String name() {
        return this.name;
    }

    public Integer channelNumber() {
        return this.channelNumber;
    }

    public static class Builder {
        private List<Address> addresses;
        private String user;
        private String passwd;
        private String virtualHost;
        private ExecutorService executor;
        private String name = "main";
        private Integer channelNumber;

        public RabbitConfig build() {
            return new RabbitConfig(this);
        }

        public Builder address(String host, Integer port) {
            if (this.addresses == null) {
                this.addresses = new ArrayList<Address>();
            }
            this.addresses.add(new Address(host, port.intValue()));
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            addresses.forEach(address -> this.address(address.getHost(), address.getPort()));
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder virtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder channelNumber(Integer channelNumber) {
            this.channelNumber = channelNumber;
            return this;
        }
    }
}

