/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.mq.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import io.enoa.mq.rabbitmq.ERabbitMQException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class EnoaRabbit
implements Channel {
    private Channel channel;

    public EnoaRabbit(Channel channel) {
        this.channel = channel;
    }

    public Channel channel() {
        return this.channel;
    }

    private <T> T runR(_RunnerR<T> runner) {
        try {
            return runner.run();
        }
        catch (Exception e) {
            throw new ERabbitMQException(e.getMessage(), e);
        }
    }

    private void runV(_RunnerV runner) {
        try {
            runner.run();
        }
        catch (Exception e) {
            throw new ERabbitMQException(e.getMessage(), e);
        }
    }

    public int getChannelNumber() {
        return this.channel.getChannelNumber();
    }

    public Connection getConnection() {
        return this.channel.getConnection();
    }

    public void close() {
        this.runV(() -> ((Channel)this.channel).close());
    }

    public void close(int closeCode, String closeMessage) {
        this.runV(() -> this.channel.close(closeCode, closeMessage));
    }

    public void abort() {
        this.runV(() -> ((Channel)this.channel).abort());
    }

    public void abort(int closeCode, String closeMessage) {
        this.runV(() -> this.channel.abort(closeCode, closeMessage));
    }

    public void addReturnListener(ReturnListener listener) {
        this.channel.addReturnListener(listener);
    }

    public ReturnListener addReturnListener(ReturnCallback returnCallback) {
        return this.channel.addReturnListener(returnCallback);
    }

    public boolean removeReturnListener(ReturnListener listener) {
        return this.channel.removeReturnListener(listener);
    }

    public void clearReturnListeners() {
        this.channel.clearReturnListeners();
    }

    public void addConfirmListener(ConfirmListener listener) {
        this.channel.addConfirmListener(listener);
    }

    public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
        return this.channel.addConfirmListener(ackCallback, nackCallback);
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.channel.removeConfirmListener(listener);
    }

    public void clearConfirmListeners() {
        this.channel.clearConfirmListeners();
    }

    public Consumer getDefaultConsumer() {
        return this.channel.getDefaultConsumer();
    }

    public void setDefaultConsumer(Consumer consumer) {
        this.channel.setDefaultConsumer(consumer);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
        this.runV(() -> this.channel.basicQos(prefetchSize, prefetchCount, global));
    }

    public void basicQos(int prefetchCount, boolean global) {
        this.runV(() -> this.channel.basicQos(prefetchCount, global));
    }

    public void basicQos(int prefetchCount) {
        this.runV(() -> this.channel.basicQos(prefetchCount));
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) {
        this.runV(() -> this.channel.basicPublish(exchange, routingKey, props, body));
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) {
        this.runV(() -> this.channel.basicPublish(exchange, routingKey, mandatory, props, body));
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        this.runV(() -> this.channel.basicPublish(exchange, routingKey, mandatory, immediate, props, body));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable, autoDelete, arguments));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable, autoDelete, arguments));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments));
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.runV(() -> this.channel.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments));
    }

    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.runV(() -> this.channel.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) {
        return this.runR(() -> this.channel.exchangeDeclarePassive(name));
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) {
        return this.runR(() -> this.channel.exchangeDelete(exchange, ifUnused));
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) {
        this.runV(() -> this.channel.exchangeDeleteNoWait(exchange, ifUnused));
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) {
        return this.runR(() -> this.channel.exchangeDelete(exchange));
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) {
        return this.runR(() -> this.channel.exchangeBind(destination, source, routingKey));
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeBind(destination, source, routingKey, arguments));
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.runV(() -> this.channel.exchangeBindNoWait(destination, source, routingKey, arguments));
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) {
        return this.runR(() -> this.channel.exchangeUnbind(destination, source, routingKey));
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.exchangeUnbind(destination, source, routingKey, arguments));
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.runV(() -> this.channel.exchangeUnbindNoWait(destination, source, routingKey, arguments));
    }

    public AMQP.Queue.DeclareOk queueDeclare() {
        return this.runR(() -> ((Channel)this.channel).queueDeclare());
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.queueDeclare(queue, durable, exclusive, autoDelete, arguments));
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        this.runV(() -> this.channel.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments));
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) {
        return this.runR(() -> this.channel.queueDeclarePassive(queue));
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) {
        return this.runR(() -> this.channel.queueDelete(queue));
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) {
        return this.runR(() -> this.channel.queueDelete(queue, ifUnused, ifEmpty));
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) {
        this.runV(() -> this.channel.queueDeleteNoWait(queue, ifUnused, ifEmpty));
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) {
        return this.runR(() -> this.channel.queueBind(queue, exchange, routingKey));
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.queueBind(queue, exchange, routingKey, arguments));
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.runV(() -> this.channel.queueBindNoWait(queue, exchange, routingKey, arguments));
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) {
        return this.runR(() -> this.channel.queueUnbind(queue, exchange, routingKey));
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.runR(() -> this.channel.queueUnbind(queue, exchange, routingKey, arguments));
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) {
        return this.runR(() -> this.channel.queuePurge(queue));
    }

    public GetResponse basicGet(String queue, boolean autoAck) {
        return this.runR(() -> this.channel.basicGet(queue, autoAck));
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.runV(() -> this.channel.basicAck(deliveryTag, multiple));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.runV(() -> this.channel.basicNack(deliveryTag, multiple, requeue));
    }

    public void basicReject(long deliveryTag, boolean requeue) {
        this.runV(() -> this.channel.basicReject(deliveryTag, requeue));
    }

    public String basicConsume(String queue, Consumer callback) {
        return this.runR(() -> this.channel.basicConsume(queue, callback));
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, deliverCallback, cancelCallback));
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, deliverCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, callback));
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, deliverCallback, cancelCallback));
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, deliverCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, arguments, callback));
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback));
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, callback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, shutdownSignalCallback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.runR(() -> this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public void basicCancel(String consumerTag) {
        this.runV(() -> this.channel.basicCancel(consumerTag));
    }

    public AMQP.Basic.RecoverOk basicRecover() {
        return this.runR(() -> ((Channel)this.channel).basicRecover());
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) {
        return this.runR(() -> this.channel.basicRecover(requeue));
    }

    public AMQP.Tx.SelectOk txSelect() {
        return this.runR(() -> ((Channel)this.channel).txSelect());
    }

    public AMQP.Tx.CommitOk txCommit() {
        return this.runR(() -> ((Channel)this.channel).txCommit());
    }

    public AMQP.Tx.RollbackOk txRollback() {
        return this.runR(() -> ((Channel)this.channel).txRollback());
    }

    public AMQP.Confirm.SelectOk confirmSelect() {
        return this.runR(() -> ((Channel)this.channel).confirmSelect());
    }

    public long getNextPublishSeqNo() {
        return this.channel.getNextPublishSeqNo();
    }

    public boolean waitForConfirms() {
        return this.runR(() -> ((Channel)this.channel).waitForConfirms());
    }

    public boolean waitForConfirms(long timeout) {
        return this.runR(() -> this.channel.waitForConfirms(timeout));
    }

    public void waitForConfirmsOrDie() {
        this.runV(() -> ((Channel)this.channel).waitForConfirmsOrDie());
    }

    public void waitForConfirmsOrDie(long timeout) {
        this.runV(() -> this.channel.waitForConfirmsOrDie(timeout));
    }

    public void asyncRpc(Method method) {
        this.runV(() -> this.channel.asyncRpc(method));
    }

    public Command rpc(Method method) {
        return this.runR(() -> this.channel.rpc(method));
    }

    public long messageCount(String queue) {
        return this.runR(() -> this.channel.messageCount(queue));
    }

    public long consumerCount(String queue) {
        return this.runR(() -> this.channel.consumerCount(queue));
    }

    public CompletableFuture<Command> asyncCompletableRpc(Method method) {
        return this.runR(() -> this.channel.asyncCompletableRpc(method));
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.channel.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.channel.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.channel.getCloseReason();
    }

    public void notifyListeners() {
        this.channel.notifyListeners();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @FunctionalInterface
    private static interface _RunnerV {
        public void run() throws Exception;
    }

    @FunctionalInterface
    private static interface _RunnerR<T> {
        public T run() throws Exception;
    }
}

