/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.mq.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.enoa.mq.rabbitmq.ERabbitMQException;
import io.enoa.mq.rabbitmq.EnoaRabbit;
import io.enoa.mq.rabbitmq.RabbitConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EPMRabbit {
    private Map<String, EnoaRabbit> rabbitMap = new ConcurrentHashMap<String, EnoaRabbit>();

    public static EPMRabbit instance() {
        return Holder.INSTANCE;
    }

    private boolean existsName(String name) {
        return this.rabbitMap.containsKey(name);
    }

    public void install(RabbitConfig config) {
        if (this.existsName(config.name())) {
            throw new ERabbitMQException("This RabbitMQ name is exists. => " + config.name());
        }
        ConnectionFactory factory = new ConnectionFactory();
        try {
            Connection connection = factory.newConnection(config.executor(), config.addresses(), config.name());
            Channel channel = config.channelNumber() != null ? connection.createChannel(config.channelNumber().intValue()) : connection.createChannel();
            this.rabbitMap.put(config.name(), new EnoaRabbit(channel));
        }
        catch (Exception e) {
            throw new ERabbitMQException(e.getMessage(), e);
        }
    }

    public EnoaRabbit rabbit(String name) {
        return this.rabbitMap.get(name);
    }

    public EnoaRabbit rabbit() {
        return this.rabbit("main");
    }

    public void close(String name) {
        EnoaRabbit rabbit = this.rabbit(name);
        if (rabbit == null) {
            return;
        }
        rabbit.close();
        try {
            rabbit.getConnection().close();
        }
        catch (Exception e) {
            throw new ERabbitMQException(e.getMessage(), e);
        }
        this.rabbitMap.remove(name);
    }

    public void close() {
        this.close("main");
    }

    private static class Holder {
        private static final EPMRabbit INSTANCE = new EPMRabbit();

        private Holder() {
        }
    }
}

