/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.promise.builder;

import io.enoa.promise.arg.PromiseArg;
import io.enoa.promise.arg.PromiseBool;
import io.enoa.promise.arg.PromiseCapture;
import io.enoa.promise.arg.PromiseThen;
import io.enoa.promise.arg.PromiseVoid;
import io.enoa.promise.builder.EPAssetPromiseBuilder;
import io.enoa.promise.builder.EPDoneArgPromiseBuilder;
import io.enoa.promise.builder.EPDonePromiseBuilder;
import io.enoa.promise.builder.EPEoPromiseBuilder;
import io.enoa.promise.builder.EPThenPromiseBuilder;
import java.util.List;

public class EPXEnoaPromiseHandleBuilder {
    static EPXEnoaPromiseHandleBuilder instance() {
        return Holder.INSTANCE;
    }

    private EPXEnoaPromiseHandleBuilder() {
    }

    public void handleAlways(EPEoPromiseBuilder builder) {
        if (builder.always() == null) {
            return;
        }
        try {
            builder.always().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleAlways(EPAssetPromiseBuilder builder) {
        this.handleAlways((EPEoPromiseBuilder)builder);
    }

    public void handleAlways(EPDoneArgPromiseBuilder builder) {
        this.handleAlways((EPEoPromiseBuilder)builder);
    }

    public void handleAlways(EPDonePromiseBuilder builder) {
        this.handleAlways((EPEoPromiseBuilder)builder);
    }

    public void handleAlways(EPThenPromiseBuilder builder) {
        this.handleAlways((EPEoPromiseBuilder)builder);
    }

    public void handleCapture(EPEoPromiseBuilder builder, Throwable throwable) {
        for (PromiseCapture capture : builder.captures()) {
            try {
                capture.execute(throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        this.handleAlways(builder);
    }

    public void handleCapture(EPAssetPromiseBuilder builder, Throwable throwable) {
        this.handleCapture((EPEoPromiseBuilder)builder, throwable);
    }

    public void handleCapture(EPDoneArgPromiseBuilder builder, Throwable throwable) {
        this.handleCapture((EPEoPromiseBuilder)builder, throwable);
    }

    public void handleCapture(EPDonePromiseBuilder builder, Throwable throwable) {
        this.handleCapture((EPEoPromiseBuilder)builder, throwable);
    }

    public void handleCapture(EPThenPromiseBuilder builder, Throwable throwable) {
        this.handleCapture((EPEoPromiseBuilder)builder, throwable);
    }

    public <T> void handleDoneArg(EPDoneArgPromiseBuilder<T> builder, T result) {
        boolean needalways = true;
        for (PromiseArg<T> done : builder.dones()) {
            try {
                done.execute(result);
            }
            catch (Exception e) {
                this.handleCapture(builder, (Throwable)e);
                needalways = false;
                break;
            }
        }
        if (!needalways) {
            return;
        }
        this.handleAlways(builder);
    }

    public void handleDone(EPDonePromiseBuilder builder) {
        boolean needalways = true;
        for (PromiseVoid done : builder.dones()) {
            try {
                done.execute();
            }
            catch (Exception e) {
                this.handleCapture(builder, (Throwable)e);
                needalways = false;
                break;
            }
        }
        if (!needalways) {
            return;
        }
        this.handleAlways(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleThen(EPThenPromiseBuilder builder, Object result) {
        try {
            List<PromiseThen> thens = builder.thens();
            for (PromiseThen promiseThen : thens) {
                result = promiseThen.execute(result);
            }
            List<PromiseArg> executers = builder.executers();
            for (PromiseArg executer : executers) {
                executer.execute(result);
            }
        }
        catch (Exception e) {
            for (PromiseCapture promiseCapture : builder.captures()) {
                try {
                    promiseCapture.execute(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    break;
                }
            }
        }
        finally {
            if (builder.always() != null) {
                builder.always().execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAsset(EPAssetPromiseBuilder builder, Object result) {
        try {
            List<PromiseBool> assets = builder.assets();
            boolean pass = Boolean.TRUE;
            for (PromiseBool promiseBool : assets) {
                if (promiseBool.execute(result)) continue;
                pass = Boolean.FALSE;
                break;
            }
            if (!pass) {
                List<PromiseArg> failthrows = builder.failthrows();
                for (PromiseArg promiseArg : failthrows) {
                    promiseArg.execute(result);
                }
                return;
            }
            List<PromiseThen> thens = builder.thens();
            for (PromiseThen promiseThen : thens) {
                result = promiseThen.execute(result);
            }
            List<PromiseArg> list = builder.executers();
            for (PromiseArg execute : list) {
                execute.execute(result);
            }
        }
        catch (Exception e) {
            List<PromiseCapture> captures = builder.captures();
            for (PromiseCapture promiseCapture : captures) {
                try {
                    promiseCapture.execute(e);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
            }
        }
        finally {
            if (builder.always() != null) {
                builder.always().execute();
            }
        }
    }

    private static class Holder {
        private static final EPXEnoaPromiseHandleBuilder INSTANCE = new EPXEnoaPromiseHandleBuilder();

        private Holder() {
        }
    }
}

