/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.promise.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AonePromiseExecutorBuilder {
    private AonePromiseExecutorBuilder() {
    }

    static AonePromiseExecutorBuilder instance() {
        return Holder.INSTANCE;
    }

    public ExecutorService enqueue(String name) {
        return this.enqueue(name, false);
    }

    public ExecutorService enqueue(String name, boolean daemon) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), runnable -> {
            Thread result = new Thread(runnable, name);
            result.setDaemon(daemon);
            return result;
        });
    }

    private static class Holder {
        private static final AonePromiseExecutorBuilder INSTANCE = new AonePromiseExecutorBuilder();

        private Holder() {
        }
    }
}

