/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.log.provider.log4j;

import io.enoa.log.EnoaLog;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class _Log4jLog
extends EnoaLog {
    private Logger log;
    private String clazzName;
    private static final String callerFQCN = _Log4jLog.class.getName();

    _Log4jLog(Class<?> clazz) {
        this(clazz.getName());
    }

    _Log4jLog(String name) {
        this.log = Logger.getLogger((String)name);
        this.clazzName = name;
    }

    private String formatMsg(String msg, Object ... args) {
        if (args == null) {
            return msg;
        }
        for (Object arg : args) {
            int ix = msg.indexOf("{}");
            if (ix == -1) continue;
            String left = msg.substring(0, ix);
            String right = msg.substring(ix + 2, msg.length());
            msg = left.concat(arg == null ? "" : arg.toString()).concat(right);
        }
        return msg;
    }

    public String name() {
        return this.clazzName;
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void trace(String msg) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)msg, null);
    }

    public void trace(String format, Object arg) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)this.formatMsg(format, arg), arg instanceof Throwable ? (Throwable)arg : null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)this.formatMsg(format, arg1, arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public void trace(String format, Object ... arguments) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)this.formatMsg(format, arguments), arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable ? (Throwable)arguments[arguments.length - 1] : null);
    }

    public void trace(String msg, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)msg, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String msg) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    public void debug(String format, Object arg) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)this.formatMsg(format, arg), arg instanceof Throwable ? (Throwable)arg : null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)this.formatMsg(format, arg1, arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public void debug(String format, Object ... arguments) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)this.formatMsg(format, arguments), arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable ? (Throwable)arguments[arguments.length - 1] : null);
    }

    public void debug(String msg, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String msg) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    public void info(String format, Object arg) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)this.formatMsg(format, arg), arg instanceof Throwable ? (Throwable)arg : null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)this.formatMsg(format, arg1, arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public void info(String format, Object ... arguments) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)this.formatMsg(format, arguments), arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable ? (Throwable)arguments[arguments.length - 1] : null);
    }

    public void info(String msg, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(String msg) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    public void warn(String format, Object arg) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)this.formatMsg(format, arg), arg instanceof Throwable ? (Throwable)arg : null);
    }

    public void warn(String format, Object ... arguments) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)this.formatMsg(format, arguments), arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable ? (Throwable)arguments[arguments.length - 1] : null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)this.formatMsg(format, arg1, arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public void warn(String msg, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(String msg) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    public void error(String format, Object arg) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)this.formatMsg(format, arg), arg instanceof Throwable ? (Throwable)arg : null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)this.formatMsg(format, arg1, arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public void error(String format, Object ... arguments) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)this.formatMsg(format, arguments), arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable ? (Throwable)arguments[arguments.length - 1] : null);
    }

    public void error(String msg, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)msg, null);
    }
}

