/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.json.provider.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapterFactory;
import io.enoa.json.EnoaJson;
import io.enoa.json.provider.gson.Gsonfig;
import io.enoa.json.provider.gson.MapTypeAdapterFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class _Gson
extends EnoaJson {
    private Map<String, Gson> CACHE = new HashMap<String, Gson>();
    private Gsonfig gsonfig;

    static _Gson instance() {
        return Holder.INSTANCE;
    }

    private _Gson() {
    }

    _Gson gsonfig(Gsonfig gsonfig) {
        this.gsonfig = gsonfig;
        return this;
    }

    private Gson gson(String datePattern) {
        Gson _gson = this.CACHE.get(datePattern == null ? "def" : datePattern);
        if (_gson != null) {
            return _gson;
        }
        GsonBuilder builder = new GsonBuilder();
        if (this.gsonfig.fixPrecision()) {
            builder.registerTypeAdapterFactory((TypeAdapterFactory)new MapTypeAdapterFactory()).registerTypeAdapter(Double.class, (src, typeOfSrc, context) -> {
                if (src == (double)src.longValue()) {
                    return new JsonPrimitive((Number)src.longValue());
                }
                return new JsonPrimitive((Number)src);
            });
        }
        if (this.gsonfig == null) {
            builder.disableHtmlEscaping().setDateFormat(datePattern == null ? "yyyy-MM-dd HH:mm:ss.SSS" : datePattern);
            _gson = builder.create();
            this.CACHE.put(datePattern, _gson);
            return _gson;
        }
        if (this.gsonfig.disableHtmlEscaping()) {
            builder.disableHtmlEscaping();
        }
        if (this.gsonfig.dateFormat() != null) {
            builder.setDateFormat(datePattern == null ? this.gsonfig.dateFormat() : datePattern);
        } else {
            builder.setDateFormat(datePattern == null ? "yyyy-MM-dd HH:mm:ss.SSS" : datePattern);
        }
        _gson = builder.create();
        this.CACHE.put(datePattern, _gson);
        return _gson;
    }

    private Gson gson() {
        return this.gson(null);
    }

    public String toJson(Object object) {
        return this.gson().toJson(object);
    }

    public String toJson(Object object, String datePattern) {
        return this.gson(datePattern).toJson(object);
    }

    public <T> T parse(String json, Class<T> type) {
        return (T)this.gson().fromJson(json, type);
    }

    public <T> T parse(String json, Type type) {
        return (T)this.gson().fromJson(json, type);
    }

    public <T> List<T> parseArray(String json, Class<T> type) {
        return (List)this.gson().fromJson(json, (Type)new _ParameterizedTypeImpl(List.class, new Class[]{type}));
    }

    static class _ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class raw;
        private final Type[] args;

        private _ParameterizedTypeImpl(Class raw, Type[] args) {
            this.raw = raw;
            this.args = args != null ? args : new Type[]{};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    private static class Holder {
        private static final _Gson INSTANCE = new _Gson();

        private Holder() {
        }
    }
}

