/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.json.provider.gson;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.enoa.json.provider.gson.MapObject;
import java.io.IOException;
import java.util.Map;

class MapTypeAdapter<T>
extends TypeAdapter<Map> {
    private Gson gson;
    private TypeAdapter<JsonObject> jsonobject;
    private TypeToken<T> type;

    MapTypeAdapter(Gson gson, TypeToken<T> type) {
        this.gson = gson;
        this.jsonobject = gson.getAdapter(JsonObject.class);
        this.type = type;
    }

    public void write(JsonWriter out, Map value) throws IOException {
        if (value == null) {
            this.jsonobject.write(out, (Object)new JsonObject());
            return;
        }
        JsonObject jo = MapObject.maptojsonobject(this.gson, value);
        this.jsonobject.write(out, (Object)jo);
    }

    public Map read(JsonReader in) throws IOException {
        JsonObject jo = (JsonObject)this.jsonobject.read(in);
        return MapObject.jsonobjecttomap(jo, this.type);
    }
}

