/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.json.provider.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import io.enoa.json.provider.gson.GNNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MapObject {
    MapObject() {
    }

    static JsonObject maptojsonobject(Gson gson, Map map) {
        Set set = map.entrySet();
        JsonObject jo = new JsonObject();
        set.forEach(entry -> {
            String key;
            String string = key = entry.getKey() == null ? null : entry.getKey().toString();
            if (key == null) {
                return;
            }
            Object value = entry.getValue();
            if (value == null) {
                jo.addProperty(key, (String)null);
                return;
            }
            if (value instanceof Map) {
                jo.add(key, (JsonElement)MapObject.maptojsonobject(gson, (Map)value));
                return;
            }
            if (value instanceof Collection) {
                jo.add(key, (JsonElement)MapObject.tojsonobjectcollection(gson, (Collection)value));
                return;
            }
            TypeAdapter adapter = gson.getAdapter(value.getClass());
            jo.add(key, adapter.toJsonTree(value));
        });
        return jo;
    }

    private static JsonArray tojsonobjectcollection(Gson gson, Collection collection) {
        JsonArray rets = new JsonArray(collection.size());
        collection.forEach(c -> {
            if (c == null) {
                rets.add((String)null);
                return;
            }
            if (c instanceof Map) {
                rets.add((JsonElement)MapObject.maptojsonobject(gson, (Map)c));
                return;
            }
            if (c instanceof Collection) {
                rets.add((JsonElement)MapObject.tojsonobjectcollection(gson, (Collection)c));
                return;
            }
            TypeAdapter adapter = gson.getAdapter(c.getClass());
            rets.add(adapter.toJsonTree(c));
        });
        return rets;
    }

    static <T> Map jsonobjecttomap(JsonObject jo, TypeToken<T> type) {
        Map map = MapObject.refmap(type);
        Set entries = jo.entrySet();
        entries.forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                map.put(key, MapObject.jsonobjecttomap(value.getAsJsonObject(), type));
                return;
            }
            if (value.isJsonArray()) {
                map.put(key, MapObject.tomapcollection(value.getAsJsonArray(), type));
                return;
            }
            if (value.isJsonNull()) {
                map.put(key, null);
                return;
            }
            map.put(key, MapObject.value(((JsonElement)entry.getValue()).getAsString()));
        });
        return map;
    }

    private static <T> Collection<Map> tomapcollection(JsonArray array, TypeToken<T> type) {
        ArrayList<Map> rets = new ArrayList<Map>(array.size());
        array.forEach(a -> {
            if (a.isJsonArray()) {
                rets.add((Map)((Object)MapObject.tomapcollection(a.getAsJsonArray(), type)));
                return;
            }
            if (a.isJsonObject()) {
                rets.add(MapObject.jsonobjecttomap(a.getAsJsonObject(), type));
                return;
            }
            if (a.isJsonNull()) {
                rets.add(null);
                return;
            }
            String string = a.getAsString();
            rets.add((Map)MapObject.value(string));
        });
        return rets;
    }

    private static <T> Map refmap(TypeToken<T> type) {
        try {
            Class clazz = type.getRawType();
            if (clazz == Map.class) {
                return new HashMap();
            }
            Map map = (Map)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Object value(String text) {
        if ("true".equals(text)) {
            return Boolean.TRUE;
        }
        if ("false".equals(text)) {
            return Boolean.FALSE;
        }
        if (GNNumber.isNumber(text)) {
            return GNNumber.number(text);
        }
        return text;
    }
}

