/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.json.provider.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.enoa.json.EnoaJson;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class _Gson
extends EnoaJson {
    private Map<String, Gson> CACHE = new HashMap<String, Gson>();

    static EnoaJson instance() {
        return Holder.INSTANCE;
    }

    private _Gson() {
    }

    private Gson gson(String datePattern) {
        Gson _gson = this.CACHE.get(datePattern == null ? "def" : datePattern);
        if (_gson != null) {
            return _gson;
        }
        if (datePattern == null) {
            _gson = new Gson();
            this.CACHE.put("def", _gson);
            return _gson;
        }
        _gson = new GsonBuilder().setDateFormat(datePattern).create();
        this.CACHE.put(datePattern, _gson);
        return _gson;
    }

    private Gson gson() {
        return this.gson(null);
    }

    public String toJson(Object object) {
        return this.gson().toJson(object);
    }

    public String toJson(Object object, String datePattern) {
        return this.gson(datePattern).toJson(object);
    }

    public <T> T parse(String json, Class<T> type) {
        return (T)this.gson().fromJson(json, type);
    }

    public <T> T parse(String json, Type type) {
        return (T)this.gson().fromJson(json, type);
    }

    public <T> List<T> parseArray(String json, Class<T> type) {
        return (List)this.gson().fromJson(json, (Type)new _ParameterizedTypeImpl(List.class, new Class[]{type}));
    }

    static class _ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class raw;
        private final Type[] args;

        private _ParameterizedTypeImpl(Class raw, Type[] args) {
            this.raw = raw;
            this.args = args != null ? args : new Type[]{};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    private static class Holder {
        private static final EnoaJson INSTANCE = new _Gson();

        private Holder() {
        }
    }
}

