/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.provider.httphelper.async;

import io.enoa.chunk.Chunk;
import io.enoa.http.EoEmit;
import io.enoa.http.EoUrl;
import io.enoa.http.protocol.HttpResponse;
import io.enoa.http.provider.httphelper.async.HttpHelperPromiseBuilder;
import io.enoa.promise.arg.PromiseArg;
import io.enoa.promise.arg.PromiseBool;
import io.enoa.promise.arg.PromiseThen;

class HttpHelperAsync
implements Runnable {
    private final EoEmit emit;
    private final String name;
    private final HttpHelperPromiseBuilder promise;
    private final Chunk chunk;

    HttpHelperAsync(EoUrl url, EoEmit emit, HttpHelperPromiseBuilder promise, Chunk chunk) {
        String utx = url.end();
        this.name = utx.substring(0, utx.length() < 70 ? utx.length() : 70).concat("...");
        this.emit = emit;
        this.promise = promise;
        this.chunk = chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.name);
        try {
            HttpResponse resp = this.chunk == null ? this.emit.emit() : this.emit.chunk(this.chunk);
            int code = resp.code();
            if (this.promise.oks() != null && code < 400) {
                this.promise.oks().forEach(ok -> ok.execute((Object)resp));
            }
            if (this.promise.errors() != null && code >= 400) {
                this.promise.errors().forEach(error -> error.execute((Object)resp));
            }
            Object value = resp;
            if (this.promise.thens() != null) {
                for (PromiseThen then : this.promise.thens()) {
                    value = then.execute(value);
                }
            }
            boolean pass = true;
            if (this.promise.valids() != null) {
                for (PromiseBool valid : this.promise.valids()) {
                    if (valid.execute(value)) continue;
                    pass = false;
                    break;
                }
            }
            if (pass) {
                if (this.promise.execs() != null) {
                    for (PromiseArg execute : this.promise.execs()) {
                        execute.execute(value);
                    }
                }
                return;
            }
            if (this.promise.fails() != null) {
                for (PromiseArg execute : this.promise.fails()) {
                    execute.execute(value);
                }
            }
        }
        catch (Exception e) {
            if (this.promise.captures() == null) {
                e.printStackTrace();
                return;
            }
            this.promise.captures().forEach(capture -> capture.execute((Throwable)e));
        }
        finally {
            if (this.promise.always() != null) {
                this.promise.always().execute();
            }
            Thread.currentThread().setName(oldName);
        }
    }
}

