/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import io.enoa.http.kit.SafeURL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HttpPara {
    private final String name;
    private final String value;
    private final boolean array;

    public HttpPara(String name, String value) {
        this(name, value, false);
    }

    public HttpPara(String name, String value, boolean array) {
        if (name == null) {
            throw new IllegalArgumentException("Http para name can not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Http para value can not be null. => " + name);
        }
        this.name = name;
        this.value = value;
        this.array = array;
    }

    public static String output(Collection<HttpPara> paras) {
        return HttpPara.output(paras, (boolean)Boolean.TRUE, Charset.forName("UTF-8"));
    }

    public static String output(Collection<HttpPara> paras, boolean traditional, Charset charset) {
        StringBuilder text = new StringBuilder();
        paras.forEach(para -> text.append(para.output(traditional, charset)).append("&"));
        return text.deleteCharAt(text.length() - 1).toString();
    }

    public static String output(HttpPara para) {
        return HttpPara.output(para, (boolean)Boolean.TRUE, Charset.forName("UTF-8"));
    }

    public static String output(HttpPara para, boolean traditional, Charset charset) {
        return para.output(traditional, charset);
    }

    @Deprecated
    public static Set<HttpPara> parse(String text) {
        return HttpPara.of(text);
    }

    public static Set<HttpPara> of(String text) {
        if (text == null || "".equals(text)) {
            return Collections.emptySet();
        }
        if (text.contains("?")) {
            String string = text = text.startsWith("http://") || text.startsWith("https://") ? text.substring(text.indexOf("?") + 1) : text;
            if ("".equals(text)) {
                return Collections.emptySet();
            }
        }
        String[] paraItems = text.split("&");
        HashSet<HttpPara> paras = new HashSet<HttpPara>();
        for (String paraItem : paraItems) {
            int eqIx = paraItem.indexOf("=");
            if (eqIx == -1) continue;
            String name = paraItem.substring(0, eqIx);
            String value = paraItem.substring(eqIx + 1);
            if ("".equals(name) || "".equals(value)) continue;
            paras.add(new HttpPara(name, value));
        }
        return paras;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean array() {
        return this.array;
    }

    public String output(boolean traditional, Charset charset) {
        StringBuilder para = new StringBuilder();
        para.append(SafeURL.encode(this.name, charset));
        if (!traditional && this.array) {
            para.append("[]");
        }
        para.append("=");
        para.append(SafeURL.encode(this.value, charset));
        return para.toString();
    }

    public String output(boolean traditional) {
        StringBuilder para = new StringBuilder();
        para.append(this.name);
        if (!traditional && this.array) {
            para.append("[]");
        }
        para.append("=");
        para.append(this.value);
        return para.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result += this.array ? 0 : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpPara)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HttpPara that = (HttpPara)obj;
        return this.name.equals(that.name) && this.value.equals(that.value) && this.array == that.array;
    }

    public String toString() {
        return String.format("%s=%s (%s)", this.name, this.value, this.array ? "array" : "single");
    }
}

