/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.provider.httphelper.http.resp;

import io.enoa.chunk.Chunk;
import io.enoa.chunk.ChunkCaller;
import io.enoa.http.EoHttpConfig;
import io.enoa.http.protocol.HttpResponseBody;
import io.enoa.http.provider.httphelper.http.resp.AbstractResponse;
import io.enoa.http.provider.httphelper.http.resp._HttpHelperResponse;
import io.enoa.http.provider.httphelper.http.resp._IBodyExtra;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Set;

public class _HttpHelperChunkedResponse
extends AbstractResponse {
    public _HttpHelperChunkedResponse(EoHttpConfig config, HttpURLConnection conn, InputStream inputstream, Charset charset, Chunk chunk) {
        super(config, conn, inputstream, charset);
        super.extrabody(this.extra(chunk, charset));
    }

    private _IBodyExtra extra(Chunk chunk, Charset charset) {
        return stream -> {
            String transferencoding = super.header("Transfer-Encoding");
            boolean ischunked = "chunked".equalsIgnoreCase(transferencoding);
            if (!ischunked) {
                Set<String> chunktypes = this.config().chunktype();
                for (String chunktype : chunktypes) {
                    if (!chunktype.equalsIgnoreCase(super.header("Content-Type"))) continue;
                    ischunked = true;
                    break;
                }
            }
            if (!ischunked || chunk == null) {
                return _HttpHelperResponse.extra(charset).extra(stream);
            }
            return this.chunkread(stream, chunk, charset);
        };
    }

    private HttpResponseBody chunkread(InputStream stream, Chunk chunk, Charset charset) throws IOException {
        ChunkCaller caller = chunk.caller();
        try (ByteArrayOutputStream swap = new ByteArrayOutputStream();){
            int rc;
            byte[] buff = new byte[2048];
            while ((rc = stream.read(buff)) != -1) {
                caller.call(Arrays.copyOf(buff, rc));
                swap.write(buff, 0, rc);
            }
            byte[] bytes = swap.toByteArray();
            caller.destroy();
            HttpResponseBody httpResponseBody = HttpResponseBody.create(bytes, super.charset());
            return httpResponseBody;
        }
    }
}

