/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.provider.httphelper;

import io.enoa.http.EoHttpConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HttpHelperConfig
implements EoHttpConfig {
    private final int connectionTimeout;
    private final int soTimeout;
    private final boolean debug;
    private final Set<String> chunktype;

    private HttpHelperConfig(Builder builder) {
        this.connectionTimeout = builder.connectionTimeout;
        this.soTimeout = builder.soTimeout;
        this.debug = builder.debug;
        this.chunktype = builder.chunktype;
    }

    public HttpHelperConfig(EoHttpConfig config) {
        this(new Builder(config));
    }

    @Override
    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int soTimeout() {
        return this.soTimeout;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public Set<String> chunktype() {
        return this.chunktype == null ? Collections.emptySet() : this.chunktype;
    }

    public static class Builder {
        private int connectionTimeout = 20000;
        private int soTimeout = 30000;
        private boolean debug = Boolean.FALSE;
        private Set<String> chunktype;

        public Builder() {
        }

        private Builder(EoHttpConfig config) {
            this();
            this.connectionTimeout = config.connectionTimeout();
            this.soTimeout = config.soTimeout();
            this.chunktype = config.chunktype();
        }

        public HttpHelperConfig build() {
            return new HttpHelperConfig(this);
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder debug() {
            return this.debug(Boolean.TRUE);
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder chunktype(String chunktype) {
            if (this.chunktype == null) {
                this.chunktype = new HashSet<String>();
            }
            this.chunktype.add(chunktype);
            return this;
        }

        public Builder chunktype(Set<String> chunktype) {
            this.chunktype = chunktype;
            return this;
        }
    }
}

