/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.chunk;

import io.enoa.chunk.ChunkCaller;
import io.enoa.chunk.IChunkConverter;
import io.enoa.chunk.IChunkRunner;
import io.enoa.chunk.IChunkStopper;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class Chunk
implements Serializable {
    private IChunkRunner<byte[]> runner;
    private IChunkStopper stopper;
    private ChunkCaller caller;

    public static Builder builder(IChunkRunner<byte[]> runner) {
        return new Builder(runner);
    }

    public static <RET> Chunk generic(IChunkConverter<RET> converter, IChunkRunner<RET> runner, IChunkStopper stopper) {
        return Chunk.builder((bytes, linebreak) -> runner.run(converter.convert((byte[])bytes), linebreak)).stopper(stopper).build();
    }

    public static <RET> Chunk generic(IChunkConverter<RET> converter, IChunkRunner<RET> runner) {
        return Chunk.generic(converter, runner, IChunkStopper.def());
    }

    public static Chunk string(IChunkRunner<String> runner, Charset charset, IChunkStopper stopper) {
        return Chunk.builder((bytes, linebreak) -> runner.run(Chunk.string(bytes, charset), linebreak)).stopper(stopper).build();
    }

    public static Chunk string(IChunkRunner<String> runner, Charset charset) {
        return Chunk.string(runner, charset, IChunkStopper.def());
    }

    public static Chunk string(IChunkRunner<String> runner) {
        return Chunk.string(runner, StandardCharsets.UTF_8, IChunkStopper.def());
    }

    private static String string(byte[] bytes, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = CharBuffer.allocate(byteBuffer.limit());
        decoder.decode(byteBuffer, charBuffer, true);
        charBuffer.flip();
        String ret = charBuffer.toString();
        charBuffer.clear();
        byteBuffer.clear();
        return ret;
    }

    private Chunk(Builder builder) {
        this.runner = builder.runner;
        this.stopper = builder.stopper;
        this.caller = new ChunkCaller(this);
    }

    public ChunkCaller caller() {
        return this.caller;
    }

    public IChunkRunner<byte[]> runner() {
        return this.runner;
    }

    public IChunkStopper stopper() {
        return this.stopper;
    }

    public static class Builder {
        private IChunkRunner<byte[]> runner;
        private IChunkStopper stopper;

        public Builder() {
        }

        public Builder(IChunkRunner<byte[]> runner) {
            this.runner = runner;
        }

        public Chunk build() {
            return new Chunk(this);
        }

        public Builder runner(IChunkRunner<byte[]> runner) {
            this.runner = runner;
            return this;
        }

        public Builder stopper(IChunkStopper stopper) {
            this.stopper = stopper;
            return this;
        }
    }
}

