/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.proxy;

import io.enoa.http.proxy.HttpProxy;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;

public class TcpProxy
implements HttpProxy {
    private String host;
    private String user;
    private String passwd;
    private int port;

    public TcpProxy(String host, int port, String user, String passwd) {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("Host can not be null");
        }
        this.host = host;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
    }

    public TcpProxy(String host, Integer port) {
        this(host, port, null, null);
    }

    @Override
    public Proxy proxy() {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
        if (this.user == null) {
            return proxy;
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(TcpProxy.this.user, (TcpProxy.this.passwd == null ? "" : TcpProxy.this.passwd).toCharArray());
            }
        });
        return proxy;
    }

    public String toString() {
        return "TcpProxy{host='" + this.host + '\'' + ", user='" + this.user + '\'' + ", passwd='" + this.passwd + '\'' + ", port=" + this.port + '}';
    }
}

