/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.kit;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class SafeURL {
    private static Map<String, String> SYMBOLMAPPING = new HashMap<String, String>();

    private static String encodeUrl(String url, Charset charset) {
        try {
            return URLEncoder.encode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void initSymbolMapping() {
        String[] symbols;
        Charset utf8 = Charset.forName("UTF-8");
        for (String symbol : symbols = new String[]{"~", "!", "@", "#", "$", "^", "&", "*", "(", ")", "=", "[", "]", "{", "}", "|", "\\", ";", ":", "'", "\"", ",", "<", ".", ">", "?", "/"}) {
            String esym = SafeURL.encodeUrl(symbol, utf8);
            SYMBOLMAPPING.put(esym, symbol);
        }
    }

    private static String reductionSymbol(String encodeUrl) {
        for (String k : SYMBOLMAPPING.keySet()) {
            encodeUrl = encodeUrl.replace(k, SYMBOLMAPPING.get(k));
        }
        return encodeUrl;
    }

    public static String encode(String url, Charset charset) {
        if (url == null) {
            throw new IllegalArgumentException("Encode url can not be null.");
        }
        return SafeURL.reductionSymbol(SafeURL.encodeUrl(url, charset));
    }

    public static String decode(String url, Charset charset) {
        if (url == null) {
            throw new IllegalArgumentException("Decode url can not be null.");
        }
        try {
            return URLDecoder.decode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    static {
        SafeURL.initSymbolMapping();
    }
}

